
/*
 * GUIMain.java
 *
 * Created on Feb 9, 2010, 9:30:35 AM
 */

package creeksidescheduler;

/**
 *
 * @author Bruce Templeton
 *
 * This Class controls the GUI, I/O, Scheduling
 */

import java.io.*;
import javax.swing.JFileChooser;

public class GUIMain extends javax.swing.JFrame {
    
    static final int CLASSES=0;//initial number of classes
    static final int SPECIALS=0;//initial number of specials
    static Classroom[] classes;//the classrooms
    static Special[] spec;//the specials
    static Classroom[] specClass;//the special Classrooms
    static String FileName;
    static int NumberOfSpecials;//current number of specials
    static int NumberOfClasses;//current number of classes
    static int NumberOfSpecialClasses;//current number of special classes
    static int SpecialCounter;//counter for special ID
    static boolean changesMade;//boolean to see if any changed have been made since last save
    static boolean waitOnBox=false;//wait while status box is open
    static int ynBoxState=0;//state of yes no pop up box 0=none;1=new;2=open


    
    private static void reset(){
        classes = new Classroom[CLASSES+1];//the classrooms
        spec = new Special[SPECIALS+1];//the specials
        specClass = new Classroom[CLASSES+1];//the special Classrooms
        NumberOfSpecials=SPECIALS;//current number of specials
        NumberOfClasses=CLASSES;//current number of classes
        NumberOfSpecialClasses=CLASSES;//current number of special classes
        SpecialCounter=0;//counter for special ID
    }

    public static void main(String args[]) {
        reset();
        classes[0] = new Classroom();
        specClass[0] = new Classroom();
        spec[0] = new Special();
        spec[0].setID(0);
        classes[0].createClass();
        specClass[0].createClass();
        classes[0].setName("none");
        specClass[0].setName("none");
        FileName=null;
        changesMade=false;
        

        final GUIMain GUI = new GUIMain();

        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                GUI.setVisible(true);
            }
        });

    }

    /** Creates new form GUIMain */
    
    public GUIMain() {
        initComponents();
    }

    //display all schedules
    private void displaySched(){
        displaySched(1);
        displaySched(2);
        displaySched(3);
    }

    //display a specific schedule to window
    private void displaySched(int box) {
        if (box==1){
            jLabel_Sched1_Class_Name.setText(classes[ComboBox_Schedule1_Classes.getSelectedIndex()].getName());
            jLabel_Sched1_Class_Grade.setText(classes[ComboBox_Schedule1_Classes.getSelectedIndex()].getGrade());
            Table_Schedule1.setModel(new javax.swing.table.DefaultTableModel(createTable(classes[ComboBox_Schedule1_Classes.getSelectedIndex()]), new String[]{"Time", "Monday", "Tuesday", "Wednesday", "Thrusday", "Friday"}));
        }
        else if(box==2){
            jLabel_Sched2_Class_Name.setText(classes[ComboBox_Schedule2_Classes.getSelectedIndex()].getName());
            jLabel_Sched2_Class_Grade.setText(classes[ComboBox_Schedule2_Classes.getSelectedIndex()].getGrade());
            Table_Schedule2.setModel(new javax.swing.table.DefaultTableModel(createTable(classes[ComboBox_Schedule2_Classes.getSelectedIndex()]), new String[]{"Time", "Monday", "Tuesday", "Wednesday", "Thrusday", "Friday"}));
        }
        else if(box==3){
            jLabel_Sched3_Class_Name.setText(classes[ComboBox_Schedule3_Classes.getSelectedIndex()].getName());
            jLabel_Sched3_Class_Grade.setText(classes[ComboBox_Schedule3_Classes.getSelectedIndex()].getGrade());
            Table_Schedule3.setModel(new javax.swing.table.DefaultTableModel(createTable(classes[ComboBox_Schedule3_Classes.getSelectedIndex()]), new String[]{"Time", "Monday", "Tuesday", "Wednesday", "Thrusday", "Friday"}));
        }
    }

    private void fullReset() {
        //do a full reset
        reset();
        classes[0] = new Classroom();
        specClass[0] = new Classroom();
        spec[0] = new Special();
        spec[0].setID(0);
        classes[0].createClass();
        specClass[0].createClass();
        classes[0].setName("none");
        specClass[0].setName("none");
        FileName = null;
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        Class_Grade_Button_Group = new javax.swing.ButtonGroup();
        jLabel7 = new javax.swing.JLabel();
        jDesktopPane1 = new javax.swing.JDesktopPane();
        FrameSchedule1 = new javax.swing.JInternalFrame();
        jLabel1 = new javax.swing.JLabel();
        jLabel_Sched1_Class_Name = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        jLabel_Sched1_Class_Grade = new javax.swing.JLabel();
        ComboBox_Schedule1_Classes = new javax.swing.JComboBox();
        jLabel3 = new javax.swing.JLabel();
        jScrollPane1 = new javax.swing.JScrollPane();
        Table_Schedule1 = new javax.swing.JTable();
        FrameSpecial = new javax.swing.JInternalFrame();
        jLabel4 = new javax.swing.JLabel();
        TextField_Spec_SpecName = new javax.swing.JTextField();
        ComboBox_Special_ChSpecial = new javax.swing.JComboBox();
        jLabel5 = new javax.swing.JLabel();
        jLabel6 = new javax.swing.JLabel();
        jSeparator1 = new javax.swing.JSeparator();
        RadioB_Special_Class = new javax.swing.JRadioButton();
        RadioB_Special_Grade = new javax.swing.JRadioButton();
        ComboBox_Special_Class = new javax.swing.JComboBox();
        ComboBox_Special_Grade = new javax.swing.JComboBox();
        Check_Special_Daily = new javax.swing.JCheckBox();
        Check_Special_GTClass = new javax.swing.JCheckBox();
        ComboBox_Special_GTClass = new javax.swing.JComboBox();
        Check_Special_Manual = new javax.swing.JCheckBox();
        Man_Start = new javax.swing.JLabel();
        Auto_Start = new javax.swing.JLabel();
        Man_End = new javax.swing.JLabel();
        Auto_End = new javax.swing.JLabel();
        MST_ComboBox = new javax.swing.JComboBox();
        MET_ComboBox = new javax.swing.JComboBox();
        AST_ComboBox = new javax.swing.JComboBox();
        AET_ComboBox = new javax.swing.JComboBox();
        Auto_LNG = new javax.swing.JLabel();
        Auto_Time = new javax.swing.JTextField();
        Button_Special_Save = new javax.swing.JButton();
        Button_Special_Del = new javax.swing.JButton();
        Button_Special_Revert = new javax.swing.JButton();
        ComboBox_Special_DOW = new javax.swing.JComboBox();
        TextField_Special_Conflict = new javax.swing.JTextField();
        FrameClass = new javax.swing.JInternalFrame();
        Label_Class_Name = new javax.swing.JLabel();
        Text_Class_Name = new javax.swing.JTextField();
        jLabel9 = new javax.swing.JLabel();
        ComboBox_Class_Class = new javax.swing.JComboBox();
        Label_Class_Grade = new javax.swing.JLabel();
        Class_Grade_ComboBox = new javax.swing.JComboBox();
        Button_Class_Save = new javax.swing.JButton();
        Button_Class_Del = new javax.swing.JButton();
        Button_Class_Revert = new javax.swing.JButton();
        jTabbedPane1 = new javax.swing.JTabbedPane();
        Frame_YN_Save = new javax.swing.JInternalFrame();
        Button_YN_Save = new javax.swing.JButton();
        Button_YN_No = new javax.swing.JButton();
        jLabel8 = new javax.swing.JLabel();
        Button_YN_SaveAs = new javax.swing.JButton();
        Frame_PopUp = new javax.swing.JInternalFrame();
        Button_PU_OK = new javax.swing.JButton();
        Label_PU_Text = new javax.swing.JLabel();
        FrameSchedule2 = new javax.swing.JInternalFrame();
        jLabel10 = new javax.swing.JLabel();
        jLabel_Sched2_Class_Name = new javax.swing.JLabel();
        jLabel11 = new javax.swing.JLabel();
        jLabel_Sched2_Class_Grade = new javax.swing.JLabel();
        ComboBox_Schedule2_Classes = new javax.swing.JComboBox();
        jLabel12 = new javax.swing.JLabel();
        jScrollPane2 = new javax.swing.JScrollPane();
        Table_Schedule2 = new javax.swing.JTable();
        FrameSchedule3 = new javax.swing.JInternalFrame();
        jLabel13 = new javax.swing.JLabel();
        jLabel_Sched3_Class_Name = new javax.swing.JLabel();
        jLabel14 = new javax.swing.JLabel();
        jLabel_Sched3_Class_Grade = new javax.swing.JLabel();
        ComboBox_Schedule3_Classes = new javax.swing.JComboBox();
        jLabel15 = new javax.swing.JLabel();
        jScrollPane3 = new javax.swing.JScrollPane();
        Table_Schedule3 = new javax.swing.JTable();
        MenuBar = new javax.swing.JMenuBar();
        MFile = new javax.swing.JMenu();
        FNew_Sched = new javax.swing.JMenuItem();
        FOpen_Sched = new javax.swing.JMenuItem();
        FImport_Spec = new javax.swing.JMenuItem();
        FExport = new javax.swing.JMenuItem();
        FSave = new javax.swing.JMenuItem();
        FSave_As = new javax.swing.JMenuItem();
        FQuit = new javax.swing.JMenuItem();
        MEdit = new javax.swing.JMenu();
        EAdd_Spec = new javax.swing.JMenuItem();
        EAdd_Class = new javax.swing.JMenuItem();
        EAuto_Sched = new javax.swing.JMenuItem();
        MView = new javax.swing.JMenu();
        VSchedule1 = new javax.swing.JMenuItem();
        VSchedule2 = new javax.swing.JMenuItem();
        VSchedule3 = new javax.swing.JMenuItem();
        VSpecial = new javax.swing.JMenuItem();
        VClass = new javax.swing.JMenuItem();

        jLabel7.setText("jLabel7");

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setName("MainFrame"); // NOI18N

        FrameSchedule1.setClosable(true);
        FrameSchedule1.setDefaultCloseOperation(javax.swing.WindowConstants.HIDE_ON_CLOSE);
        FrameSchedule1.setMaximizable(true);
        FrameSchedule1.setResizable(true);
        FrameSchedule1.setTitle("Schedule 1");
        FrameSchedule1.setVisible(true);

        jLabel1.setText("Class");

        jLabel_Sched1_Class_Name.setText("none");

        jLabel2.setText("Grade");

        ComboBox_Schedule1_Classes.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "none" }));
        ComboBox_Schedule1_Classes.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                ComboBox_Schedule1_ClassesActionPerformed(evt);
            }
        });

        jLabel3.setText("Choose Class");

        Table_Schedule1.setModel(new javax.swing.table.DefaultTableModel(
            createTable(classes[ComboBox_Schedule1_Classes.getSelectedIndex()]),
            new String [] {
                "Time", "Monday", "Tuesday", "Wednesday", "Thrusday", "Friday"
            }
        ));
        jScrollPane1.setViewportView(Table_Schedule1);

        org.jdesktop.layout.GroupLayout FrameSchedule1Layout = new org.jdesktop.layout.GroupLayout(FrameSchedule1.getContentPane());
        FrameSchedule1.getContentPane().setLayout(FrameSchedule1Layout);
        FrameSchedule1Layout.setHorizontalGroup(
            FrameSchedule1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(FrameSchedule1Layout.createSequentialGroup()
                .add(FrameSchedule1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(FrameSchedule1Layout.createSequentialGroup()
                        .addContainerGap()
                        .add(FrameSchedule1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(FrameSchedule1Layout.createSequentialGroup()
                                .add(jLabel2)
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                .add(jLabel_Sched1_Class_Grade, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 17, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                            .add(FrameSchedule1Layout.createSequentialGroup()
                                .add(jLabel1)
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                .add(jLabel_Sched1_Class_Name, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 126, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                                .add(109, 109, 109)
                                .add(jLabel3)
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                .add(ComboBox_Schedule1_Classes, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 200, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))))
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, FrameSchedule1Layout.createSequentialGroup()
                        .addContainerGap(85, Short.MAX_VALUE)
                        .add(jScrollPane1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 628, Short.MAX_VALUE)))
                .addContainerGap())
        );
        FrameSchedule1Layout.setVerticalGroup(
            FrameSchedule1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(FrameSchedule1Layout.createSequentialGroup()
                .addContainerGap()
                .add(FrameSchedule1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel1)
                    .add(jLabel_Sched1_Class_Name)
                    .add(jLabel3)
                    .add(ComboBox_Schedule1_Classes, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(FrameSchedule1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel2)
                    .add(jLabel_Sched1_Class_Grade, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 16, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jScrollPane1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 277, Short.MAX_VALUE)
                .addContainerGap())
        );

        FrameSchedule1.setBounds(0, 0, 757, 416);
        jDesktopPane1.add(FrameSchedule1, javax.swing.JLayeredPane.DEFAULT_LAYER);

        FrameSpecial.setClosable(true);
        FrameSpecial.setDefaultCloseOperation(javax.swing.WindowConstants.HIDE_ON_CLOSE);
        FrameSpecial.setTitle("Special Editor");
        FrameSpecial.setMinimumSize(new java.awt.Dimension(150, 300));
        FrameSpecial.setVisible(true);

        jLabel4.setText("Special Name");

        TextField_Spec_SpecName.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                TextField_Spec_SpecNameActionPerformed(evt);
            }
        });

        ComboBox_Special_ChSpecial.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "none", "Add Special" }));
        ComboBox_Special_ChSpecial.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                ComboBox_Special_ChSpecialActionPerformed(evt);
            }
        });

        jLabel5.setText("Choose Special");

        jLabel6.setText("Existing Conflict");

        Class_Grade_Button_Group.add(RadioB_Special_Class);
        RadioB_Special_Class.setText("Class");
        RadioB_Special_Class.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                RadioB_Special_ClassActionPerformed(evt);
            }
        });

        Class_Grade_Button_Group.add(RadioB_Special_Grade);
        RadioB_Special_Grade.setText("Grade");
        RadioB_Special_Grade.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                RadioB_Special_GradeActionPerformed(evt);
            }
        });

        ComboBox_Special_Class.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "none" }));
        ComboBox_Special_Class.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                ComboBox_Special_ClassActionPerformed(evt);
            }
        });

        ComboBox_Special_Grade.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "K", "1", "2", "3", "4", "5" }));
        ComboBox_Special_Grade.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                ComboBox_Special_GradeActionPerformed(evt);
            }
        });

        Check_Special_Daily.setText("Daily");
        Check_Special_Daily.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                Check_Special_DailyActionPerformed(evt);
            }
        });

        Check_Special_GTClass.setText("Go To Classroom");
        Check_Special_GTClass.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                Check_Special_GTClassActionPerformed(evt);
            }
        });

        ComboBox_Special_GTClass.setModel(new javax.swing.DefaultComboBoxModel(updateSpecialComboList()));
        ComboBox_Special_GTClass.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                ComboBox_Special_GTClassActionPerformed(evt);
            }
        });

        Check_Special_Manual.setSelected(true);
        Check_Special_Manual.setText("Manually Place");
        Check_Special_Manual.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                Check_Special_ManualActionPerformed(evt);
            }
        });

        Man_Start.setText("Start Time");

        Auto_Start.setText("Earliest Start Time");

        Man_End.setText("End Time");

        Auto_End.setText("Latest End Time");

        MST_ComboBox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "09:00", "09:05", "09:10", "09:15", "09:20", "09:25", "09:30", "09:35", "09:40", "09:45", "09:50", "09:55", "10:00", "10:05", "10:10", "10:15", "10:20", "10:25", "10:30", "10:35", "10:40", "10:45", "10:50", "10:55", "11:00", "11:05", "11:10", "11:15", "11:20", "11:25", "11:30", "11:35", "11:40", "11:45", "11:50", "11:55", "12:00", "12:05", "12:10", "12:15", "12:20", "12:25", "12:30", "12:35", "12:40", "12:45", "12:50", "12:55", "01:00", "01:05", "01:10", "01:15", "01:20", "01:25", "01:30", "01:35", "01:40", "01:45", "01:50", "01:55", "02:00", "02:05", "02:10", "02:15", "02:20", "02:25", "02:30", "02:35", "02:40", "02:45", "02:50", "02:55", "03:00", "03:05", "03:10", "03:15", "03:20", "03:25" }));
        MST_ComboBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                MST_ComboBoxActionPerformed(evt);
            }
        });

        MET_ComboBox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "09:00", "09:05", "09:10", "09:15", "09:20", "09:25", "09:30", "09:35", "09:40", "09:45", "09:50", "09:55", "10:00", "10:05", "10:10", "10:15", "10:20", "10:25", "10:30", "10:35", "10:40", "10:45", "10:50", "10:55", "11:00", "11:05", "11:10", "11:15", "11:20", "11:25", "11:30", "11:35", "11:40", "11:45", "11:50", "11:55", "12:00", "12:05", "12:10", "12:15", "12:20", "12:25", "12:30", "12:35", "12:40", "12:45", "12:50", "12:55", "01:00", "01:05", "01:10", "01:15", "01:20", "01:25", "01:30", "01:35", "01:40", "01:45", "01:50", "01:55", "02:00", "02:05", "02:10", "02:15", "02:20", "02:25", "02:30", "02:35", "02:40", "02:45", "02:50", "02:55", "03:00", "03:05", "03:10", "03:15", "03:20", "03:25", "03:30" }));
        MET_ComboBox.setSelectedIndex(1);
        MET_ComboBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                MET_ComboBoxActionPerformed(evt);
            }
        });

        AST_ComboBox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "09:00", "09:05", "09:10", "09:15", "09:20", "09:25", "09:30", "09:35", "09:40", "09:45", "09:50", "09:55", "10:00", "10:05", "10:10", "10:15", "10:20", "10:25", "10:30", "10:35", "10:40", "10:45", "10:50", "10:55", "11:00", "11:05", "11:10", "11:15", "11:20", "11:25", "11:30", "11:35", "11:40", "11:45", "11:50", "11:55", "12:00", "12:05", "12:10", "12:15", "12:20", "12:25", "12:30", "12:35", "12:40", "12:45", "12:50", "12:55", "01:00", "01:05", "01:10", "01:15", "01:20", "01:25", "01:30", "01:35", "01:40", "01:45", "01:50", "01:55", "02:00", "02:05", "02:10", "02:15", "02:20", "02:25", "02:30", "02:35", "02:40", "02:45", "02:50", "02:55", "03:00", "03:05", "03:10", "03:15", "03:20", "03:25" }));
        AST_ComboBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                AST_ComboBoxActionPerformed(evt);
            }
        });

        AET_ComboBox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "09:00", "09:05", "09:10", "09:15", "09:20", "09:25", "09:30", "09:35", "09:40", "09:45", "09:50", "09:55", "10:00", "10:05", "10:10", "10:15", "10:20", "10:25", "10:30", "10:35", "10:40", "10:45", "10:50", "10:55", "11:00", "11:05", "11:10", "11:15", "11:20", "11:25", "11:30", "11:35", "11:40", "11:45", "11:50", "11:55", "12:00", "12:05", "12:10", "12:15", "12:20", "12:25", "12:30", "12:35", "12:40", "12:45", "12:50", "12:55", "01:00", "01:05", "01:10", "01:15", "01:20", "01:25", "01:30", "01:35", "01:40", "01:45", "01:50", "01:55", "02:00", "02:05", "02:10", "02:15", "02:20", "02:25", "02:30", "02:35", "02:40", "02:45", "02:50", "02:55", "03:00", "03:05", "03:10", "03:15", "03:20", "03:25", "03:30" }));
        AET_ComboBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                AET_ComboBoxActionPerformed(evt);
            }
        });

        Auto_LNG.setText("Length in Minutes");

        Auto_Time.setText("120");
        Auto_Time.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                Auto_TimeActionPerformed(evt);
            }
        });

        Button_Special_Save.setText("Save");
        Button_Special_Save.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                Button_Special_SaveActionPerformed(evt);
            }
        });

        Button_Special_Del.setText("Delete");
        Button_Special_Del.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                Button_Special_DelActionPerformed(evt);
            }
        });

        Button_Special_Revert.setText("Revert Changes");
        Button_Special_Revert.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                Button_Special_RevertActionPerformed(evt);
            }
        });

        ComboBox_Special_DOW.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Mon", "Tue", "Wed", "Thu", "Fri" }));
        ComboBox_Special_DOW.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                ComboBox_Special_DOWActionPerformed(evt);
            }
        });

        TextField_Special_Conflict.setText("No Conflicts");
        TextField_Special_Conflict.setEnabled(false);

        org.jdesktop.layout.GroupLayout FrameSpecialLayout = new org.jdesktop.layout.GroupLayout(FrameSpecial.getContentPane());
        FrameSpecial.getContentPane().setLayout(FrameSpecialLayout);
        FrameSpecialLayout.setHorizontalGroup(
            FrameSpecialLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(FrameSpecialLayout.createSequentialGroup()
                .add(FrameSpecialLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(FrameSpecialLayout.createSequentialGroup()
                        .addContainerGap()
                        .add(Check_Special_Manual))
                    .add(FrameSpecialLayout.createSequentialGroup()
                        .add(FrameSpecialLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                            .add(org.jdesktop.layout.GroupLayout.LEADING, FrameSpecialLayout.createSequentialGroup()
                                .addContainerGap()
                                .add(Auto_LNG)
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                .add(Auto_Time, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 46, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                            .add(org.jdesktop.layout.GroupLayout.LEADING, FrameSpecialLayout.createSequentialGroup()
                                .add(19, 19, 19)
                                .add(FrameSpecialLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                                    .add(RadioB_Special_Class)
                                    .add(RadioB_Special_Grade))
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                .add(FrameSpecialLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                                    .add(ComboBox_Special_Grade, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                                    .add(FrameSpecialLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                                        .add(MST_ComboBox, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                                        .add(ComboBox_Special_Class, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 142, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))))
                            .add(org.jdesktop.layout.GroupLayout.LEADING, FrameSpecialLayout.createSequentialGroup()
                                .addContainerGap()
                                .add(Man_Start))
                            .add(org.jdesktop.layout.GroupLayout.LEADING, FrameSpecialLayout.createSequentialGroup()
                                .addContainerGap()
                                .add(Auto_Start)
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                .add(AST_ComboBox, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))
                        .add(FrameSpecialLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                            .add(org.jdesktop.layout.GroupLayout.LEADING, FrameSpecialLayout.createSequentialGroup()
                                .add(86, 86, 86)
                                .add(FrameSpecialLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                                    .add(FrameSpecialLayout.createSequentialGroup()
                                        .add(FrameSpecialLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                                            .add(Man_End)
                                            .add(Auto_End))
                                        .add(25, 25, 25)
                                        .add(FrameSpecialLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                                            .add(AET_ComboBox, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                                            .add(FrameSpecialLayout.createSequentialGroup()
                                                .add(MET_ComboBox, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                                                .add(18, 18, 18)
                                                .add(ComboBox_Special_DOW, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))))
                                    .add(FrameSpecialLayout.createSequentialGroup()
                                        .add(FrameSpecialLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                                            .add(Check_Special_GTClass)
                                            .add(Check_Special_Daily))
                                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                        .add(ComboBox_Special_GTClass, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))))
                            .add(org.jdesktop.layout.GroupLayout.LEADING, FrameSpecialLayout.createSequentialGroup()
                                .add(53, 53, 53)
                                .add(Button_Special_Save)
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                .add(Button_Special_Del)
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                .add(Button_Special_Revert)))
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, 21, Short.MAX_VALUE))
                    .add(FrameSpecialLayout.createSequentialGroup()
                        .add(FrameSpecialLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(FrameSpecialLayout.createSequentialGroup()
                                .add(20, 20, 20)
                                .add(jLabel4))
                            .add(FrameSpecialLayout.createSequentialGroup()
                                .addContainerGap()
                                .add(jLabel6)))
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(FrameSpecialLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(FrameSpecialLayout.createSequentialGroup()
                                .add(96, 96, 96)
                                .add(jSeparator1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 425, Short.MAX_VALUE))
                            .add(FrameSpecialLayout.createSequentialGroup()
                                .add(TextField_Spec_SpecName, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 111, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, 149, Short.MAX_VALUE)
                                .add(jLabel5)
                                .add(18, 18, 18)
                                .add(ComboBox_Special_ChSpecial, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 148, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                            .add(TextField_Special_Conflict, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 521, Short.MAX_VALUE))))
                .add(59, 59, 59))
        );
        FrameSpecialLayout.setVerticalGroup(
            FrameSpecialLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(FrameSpecialLayout.createSequentialGroup()
                .add(20, 20, 20)
                .add(FrameSpecialLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel4)
                    .add(TextField_Spec_SpecName, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(jLabel5)
                    .add(ComboBox_Special_ChSpecial, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(FrameSpecialLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel6)
                    .add(TextField_Special_Conflict, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .add(3, 3, 3)
                .add(jSeparator1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 10, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(FrameSpecialLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(ComboBox_Special_Class, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(RadioB_Special_Class)
                    .add(Check_Special_Daily))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(FrameSpecialLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(ComboBox_Special_Grade, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(Check_Special_GTClass)
                    .add(RadioB_Special_Grade)
                    .add(ComboBox_Special_GTClass, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                .add(Check_Special_Manual)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(FrameSpecialLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(Man_Start)
                    .add(Man_End)
                    .add(MST_ComboBox, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(MET_ComboBox, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(ComboBox_Special_DOW, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(FrameSpecialLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(Auto_Start)
                    .add(Auto_End)
                    .add(AST_ComboBox, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(AET_ComboBox, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .add(FrameSpecialLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(FrameSpecialLayout.createSequentialGroup()
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(FrameSpecialLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                            .add(Auto_LNG)
                            .add(Auto_Time, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))
                    .add(FrameSpecialLayout.createSequentialGroup()
                        .add(15, 15, 15)
                        .add(FrameSpecialLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                            .add(Button_Special_Save)
                            .add(Button_Special_Del)
                            .add(Button_Special_Revert))))
                .add(66, 66, 66))
        );

        ComboBox_Special_Class.setEnabled(false);
        ComboBox_Special_Grade.setEnabled(false);
        ComboBox_Special_GTClass.setEnabled(false);
        Auto_Start.setVisible(false);
        Auto_End.setVisible(false);
        AST_ComboBox.setVisible(false);
        AET_ComboBox.setVisible(false);
        Auto_LNG.setVisible(false);
        Auto_Time.setVisible(false);
        Button_Class_Save.setEnabled(false);
        Button_Class_Del.setEnabled(false);
        Button_Class_Revert.setEnabled(false);

        FrameSpecial.setBounds(30, 430, 739, 340);
        jDesktopPane1.add(FrameSpecial, javax.swing.JLayeredPane.DEFAULT_LAYER);
        resetSpecialBox(0);

        FrameClass.setClosable(true);
        FrameClass.setDefaultCloseOperation(javax.swing.WindowConstants.HIDE_ON_CLOSE);
        FrameClass.setTitle("Class Editor");
        FrameClass.setVisible(true);

        Label_Class_Name.setText("Class Name");

        Text_Class_Name.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                Text_Class_NameActionPerformed(evt);
            }
        });

        jLabel9.setText("Choose Class");

        ComboBox_Class_Class.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "none", "Add New Class" }));
        ComboBox_Class_Class.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                ComboBox_Class_ClassActionPerformed(evt);
            }
        });

        Label_Class_Grade.setText("Grade");

        Class_Grade_ComboBox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "K", "1", "2", "3", "4", "5", "Special" }));

        Button_Class_Save.setText("Save");
        Button_Class_Save.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                Button_Class_SaveActionPerformed(evt);
            }
        });

        Button_Class_Del.setText("Delete");
        Button_Class_Del.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                Button_Class_DelActionPerformed(evt);
            }
        });

        Button_Class_Revert.setText("Revert Changes");
        Button_Class_Revert.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                Button_Class_RevertActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout FrameClassLayout = new org.jdesktop.layout.GroupLayout(FrameClass.getContentPane());
        FrameClass.getContentPane().setLayout(FrameClassLayout);
        FrameClassLayout.setHorizontalGroup(
            FrameClassLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(FrameClassLayout.createSequentialGroup()
                .add(FrameClassLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(FrameClassLayout.createSequentialGroup()
                        .add(FrameClassLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(FrameClassLayout.createSequentialGroup()
                                .add(20, 20, 20)
                                .add(jLabel9))
                            .add(FrameClassLayout.createSequentialGroup()
                                .addContainerGap()
                                .add(Label_Class_Name))
                            .add(FrameClassLayout.createSequentialGroup()
                                .addContainerGap()
                                .add(Label_Class_Grade)))
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(FrameClassLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(Text_Class_Name, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 165, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                            .add(ComboBox_Class_Class, 0, 213, Short.MAX_VALUE)
                            .add(Class_Grade_ComboBox, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))
                    .add(FrameClassLayout.createSequentialGroup()
                        .addContainerGap()
                        .add(Button_Class_Save)
                        .add(5, 5, 5)
                        .add(Button_Class_Del)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .add(Button_Class_Revert)))
                .addContainerGap())
            .add(org.jdesktop.layout.GroupLayout.TRAILING, FrameClassLayout.createSequentialGroup()
                .addContainerGap(246, Short.MAX_VALUE)
                .add(jTabbedPane1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .add(78, 78, 78))
        );
        FrameClassLayout.setVerticalGroup(
            FrameClassLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(FrameClassLayout.createSequentialGroup()
                .addContainerGap()
                .add(jTabbedPane1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .add(18, 18, 18)
                .add(FrameClassLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel9)
                    .add(ComboBox_Class_Class, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(FrameClassLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(Label_Class_Name)
                    .add(Text_Class_Name, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(FrameClassLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(Class_Grade_ComboBox, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(Label_Class_Grade))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .add(FrameClassLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(Button_Class_Del)
                    .add(Button_Class_Save)
                    .add(Button_Class_Revert))
                .add(69, 69, 69))
        );

        Label_Class_Name.setEnabled(false);
        Text_Class_Name.setEnabled(false);
        Label_Class_Grade.setEnabled(false);
        Class_Grade_ComboBox.setEnabled(false);
        Button_Class_Save.setEnabled(false);
        Button_Class_Del.setEnabled(false);
        Button_Class_Revert.setEnabled(false);

        FrameClass.setBounds(780, 230, 360, 230);
        jDesktopPane1.add(FrameClass, javax.swing.JLayeredPane.DEFAULT_LAYER);

        Button_YN_Save.setText("Save");
        Button_YN_Save.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                Button_YN_SaveActionPerformed(evt);
            }
        });

        Button_YN_No.setText("No");
        Button_YN_No.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                Button_YN_NoActionPerformed(evt);
            }
        });

        jLabel8.setText("Would you like to save your changes?");

        Button_YN_SaveAs.setText("Save As...");
        Button_YN_SaveAs.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                Button_YN_SaveAsActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout Frame_YN_SaveLayout = new org.jdesktop.layout.GroupLayout(Frame_YN_Save.getContentPane());
        Frame_YN_Save.getContentPane().setLayout(Frame_YN_SaveLayout);
        Frame_YN_SaveLayout.setHorizontalGroup(
            Frame_YN_SaveLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(Frame_YN_SaveLayout.createSequentialGroup()
                .add(32, 32, 32)
                .add(Frame_YN_SaveLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jLabel8)
                    .add(Frame_YN_SaveLayout.createSequentialGroup()
                        .add(Button_YN_Save)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                        .add(Button_YN_No)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .add(Button_YN_SaveAs)))
                .addContainerGap())
        );
        Frame_YN_SaveLayout.setVerticalGroup(
            Frame_YN_SaveLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, Frame_YN_SaveLayout.createSequentialGroup()
                .add(22, 22, 22)
                .add(jLabel8)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, 40, Short.MAX_VALUE)
                .add(Frame_YN_SaveLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(Button_YN_Save)
                    .add(Button_YN_No)
                    .add(Button_YN_SaveAs))
                .addContainerGap())
        );

        Frame_YN_Save.setBounds(480, 340, 320, 170);
        jDesktopPane1.add(Frame_YN_Save, javax.swing.JLayeredPane.POPUP_LAYER);

        Frame_PopUp.setDefaultCloseOperation(javax.swing.WindowConstants.HIDE_ON_CLOSE);

        Button_PU_OK.setText("OK");
        Button_PU_OK.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                Button_PU_OKActionPerformed(evt);
            }
        });

        Label_PU_Text.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        Label_PU_Text.setText("<HTML><Center>No Text</Center></HTML>");

        org.jdesktop.layout.GroupLayout Frame_PopUpLayout = new org.jdesktop.layout.GroupLayout(Frame_PopUp.getContentPane());
        Frame_PopUp.getContentPane().setLayout(Frame_PopUpLayout);
        Frame_PopUpLayout.setHorizontalGroup(
            Frame_PopUpLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(Frame_PopUpLayout.createSequentialGroup()
                .add(Frame_PopUpLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(Frame_PopUpLayout.createSequentialGroup()
                        .addContainerGap()
                        .add(Label_PU_Text, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 256, Short.MAX_VALUE))
                    .add(Frame_PopUpLayout.createSequentialGroup()
                        .add(108, 108, 108)
                        .add(Button_PU_OK)))
                .addContainerGap())
        );
        Frame_PopUpLayout.setVerticalGroup(
            Frame_PopUpLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, Frame_PopUpLayout.createSequentialGroup()
                .addContainerGap()
                .add(Label_PU_Text, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 120, Short.MAX_VALUE)
                .add(18, 18, 18)
                .add(Button_PU_OK)
                .addContainerGap())
        );

        Frame_PopUp.setBounds(520, 230, 320, 250);
        jDesktopPane1.add(Frame_PopUp, javax.swing.JLayeredPane.POPUP_LAYER);

        FrameSchedule2.setClosable(true);
        FrameSchedule2.setDefaultCloseOperation(javax.swing.WindowConstants.HIDE_ON_CLOSE);
        FrameSchedule2.setMaximizable(true);
        FrameSchedule2.setResizable(true);
        FrameSchedule2.setTitle("Schedule 2");
        FrameSchedule2.setVisible(true);

        jLabel10.setText("Class");

        jLabel_Sched2_Class_Name.setText("none");

        jLabel11.setText("Grade");

        ComboBox_Schedule2_Classes.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "none" }));
        ComboBox_Schedule2_Classes.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                ComboBox_Schedule2_ClassesActionPerformed(evt);
            }
        });

        jLabel12.setText("Choose Class");

        Table_Schedule2.setModel(new javax.swing.table.DefaultTableModel(
            createTable(classes[ComboBox_Schedule1_Classes.getSelectedIndex()]),
            new String [] {
                "Time", "Monday", "Tuesday", "Wednesday", "Thrusday", "Friday"
            }
        ));
        jScrollPane2.setViewportView(Table_Schedule2);

        org.jdesktop.layout.GroupLayout FrameSchedule2Layout = new org.jdesktop.layout.GroupLayout(FrameSchedule2.getContentPane());
        FrameSchedule2.getContentPane().setLayout(FrameSchedule2Layout);
        FrameSchedule2Layout.setHorizontalGroup(
            FrameSchedule2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(FrameSchedule2Layout.createSequentialGroup()
                .add(FrameSchedule2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(FrameSchedule2Layout.createSequentialGroup()
                        .addContainerGap()
                        .add(FrameSchedule2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(FrameSchedule2Layout.createSequentialGroup()
                                .add(jLabel11)
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                .add(jLabel_Sched2_Class_Grade, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 17, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                            .add(FrameSchedule2Layout.createSequentialGroup()
                                .add(jLabel10)
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                .add(jLabel_Sched2_Class_Name, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 126, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                                .add(109, 109, 109)
                                .add(jLabel12)
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                .add(ComboBox_Schedule2_Classes, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 200, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))))
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, FrameSchedule2Layout.createSequentialGroup()
                        .addContainerGap(85, Short.MAX_VALUE)
                        .add(jScrollPane2, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 628, Short.MAX_VALUE)))
                .addContainerGap())
        );
        FrameSchedule2Layout.setVerticalGroup(
            FrameSchedule2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(FrameSchedule2Layout.createSequentialGroup()
                .addContainerGap()
                .add(FrameSchedule2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel10)
                    .add(jLabel_Sched2_Class_Name)
                    .add(jLabel12)
                    .add(ComboBox_Schedule2_Classes, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(FrameSchedule2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel11)
                    .add(jLabel_Sched2_Class_Grade, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 16, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jScrollPane2, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 277, Short.MAX_VALUE)
                .addContainerGap())
        );

        FrameSchedule2.setBounds(30, 40, 757, 416);
        jDesktopPane1.add(FrameSchedule2, javax.swing.JLayeredPane.DEFAULT_LAYER);

        FrameSchedule3.setClosable(true);
        FrameSchedule3.setDefaultCloseOperation(javax.swing.WindowConstants.HIDE_ON_CLOSE);
        FrameSchedule3.setMaximizable(true);
        FrameSchedule3.setResizable(true);
        FrameSchedule3.setTitle("Schedule 3");
        FrameSchedule3.setVisible(true);

        jLabel13.setText("Class");

        jLabel_Sched3_Class_Name.setText("none");

        jLabel14.setText("Grade");

        ComboBox_Schedule3_Classes.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "none" }));
        ComboBox_Schedule3_Classes.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                ComboBox_Schedule3_ClassesActionPerformed(evt);
            }
        });

        jLabel15.setText("Choose Class");

        Table_Schedule3.setModel(new javax.swing.table.DefaultTableModel(
            createTable(classes[ComboBox_Schedule1_Classes.getSelectedIndex()]),
            new String [] {
                "Time", "Monday", "Tuesday", "Wednesday", "Thrusday", "Friday"
            }
        ));
        jScrollPane3.setViewportView(Table_Schedule3);

        org.jdesktop.layout.GroupLayout FrameSchedule3Layout = new org.jdesktop.layout.GroupLayout(FrameSchedule3.getContentPane());
        FrameSchedule3.getContentPane().setLayout(FrameSchedule3Layout);
        FrameSchedule3Layout.setHorizontalGroup(
            FrameSchedule3Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(FrameSchedule3Layout.createSequentialGroup()
                .add(FrameSchedule3Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(FrameSchedule3Layout.createSequentialGroup()
                        .addContainerGap()
                        .add(FrameSchedule3Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(FrameSchedule3Layout.createSequentialGroup()
                                .add(jLabel14)
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                .add(jLabel_Sched3_Class_Grade, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 17, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                            .add(FrameSchedule3Layout.createSequentialGroup()
                                .add(jLabel13)
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                .add(jLabel_Sched3_Class_Name, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 126, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                                .add(109, 109, 109)
                                .add(jLabel15)
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                .add(ComboBox_Schedule3_Classes, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 200, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))))
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, FrameSchedule3Layout.createSequentialGroup()
                        .addContainerGap(85, Short.MAX_VALUE)
                        .add(jScrollPane3, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 628, Short.MAX_VALUE)))
                .addContainerGap())
        );
        FrameSchedule3Layout.setVerticalGroup(
            FrameSchedule3Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(FrameSchedule3Layout.createSequentialGroup()
                .addContainerGap()
                .add(FrameSchedule3Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel13)
                    .add(jLabel_Sched3_Class_Name)
                    .add(jLabel15)
                    .add(ComboBox_Schedule3_Classes, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(FrameSchedule3Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel14)
                    .add(jLabel_Sched3_Class_Grade, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 16, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jScrollPane3, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 277, Short.MAX_VALUE)
                .addContainerGap())
        );

        FrameSchedule3.setBounds(70, 90, 757, 416);
        jDesktopPane1.add(FrameSchedule3, javax.swing.JLayeredPane.DEFAULT_LAYER);

        MenuBar.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                MenuBarFocusGained(evt);
            }
        });

        MFile.setText("File");

        FNew_Sched.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_N, java.awt.event.InputEvent.CTRL_MASK));
        FNew_Sched.setText("New Schedule");
        FNew_Sched.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                FNew_SchedActionPerformed(evt);
            }
        });
        MFile.add(FNew_Sched);

        FOpen_Sched.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_O, java.awt.event.InputEvent.CTRL_MASK));
        FOpen_Sched.setText("Open Schedule...");
        FOpen_Sched.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                FOpen_SchedActionPerformed(evt);
            }
        });
        MFile.add(FOpen_Sched);

        FImport_Spec.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_I, java.awt.event.InputEvent.CTRL_MASK));
        FImport_Spec.setText("Import Specials...");
        FImport_Spec.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                FImport_SpecActionPerformed(evt);
            }
        });
        MFile.add(FImport_Spec);

        FExport.setText("Export To Excell");
        FExport.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                FExportActionPerformed(evt);
            }
        });
        MFile.add(FExport);

        FSave.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_S, java.awt.event.InputEvent.CTRL_MASK));
        FSave.setText("Save");
        FSave.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                FSaveActionPerformed(evt);
            }
        });
        MFile.add(FSave);

        FSave_As.setText("Save As...");
        FSave_As.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                FSave_AsActionPerformed(evt);
            }
        });
        MFile.add(FSave_As);

        FQuit.setText("Quit");
        FQuit.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                FQuitActionPerformed(evt);
            }
        });
        MFile.add(FQuit);

        MenuBar.add(MFile);

        MEdit.setText("Edit");

        EAdd_Spec.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_S, java.awt.event.InputEvent.ALT_MASK | java.awt.event.InputEvent.CTRL_MASK));
        EAdd_Spec.setText("Add Special");
        EAdd_Spec.setActionCommand("Schedule");
        EAdd_Spec.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                EAdd_SpecActionPerformed(evt);
            }
        });
        MEdit.add(EAdd_Spec);

        EAdd_Class.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_C, java.awt.event.InputEvent.ALT_MASK | java.awt.event.InputEvent.CTRL_MASK));
        EAdd_Class.setText("Add Class");
        EAdd_Class.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                EAdd_ClassActionPerformed(evt);
            }
        });
        MEdit.add(EAdd_Class);

        EAuto_Sched.setText("Auto Schedule");
        EAuto_Sched.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                EAuto_SchedActionPerformed(evt);
            }
        });
        MEdit.add(EAuto_Sched);

        MenuBar.add(MEdit);

        MView.setText("View");

        VSchedule1.setText("Schedule 1");
        VSchedule1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                VSchedule1ActionPerformed(evt);
            }
        });
        MView.add(VSchedule1);

        VSchedule2.setText("Schedule 2");
        VSchedule2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                VSchedule2ActionPerformed(evt);
            }
        });
        MView.add(VSchedule2);

        VSchedule3.setText("Schedule 3");
        VSchedule3.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                VSchedule3ActionPerformed(evt);
            }
        });
        MView.add(VSchedule3);

        VSpecial.setText("Specials");
        VSpecial.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                VSpecialActionPerformed(evt);
            }
        });
        MView.add(VSpecial);

        VClass.setText("Classes");
        VClass.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                VClassActionPerformed(evt);
            }
        });
        MView.add(VClass);

        MenuBar.add(MView);

        setJMenuBar(MenuBar);

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jDesktopPane1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 1226, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jDesktopPane1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 872, Short.MAX_VALUE)
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void VSchedule1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_VSchedule1ActionPerformed
        FrameSchedule1.setVisible(true);
}//GEN-LAST:event_VSchedule1ActionPerformed

    private void VSpecialActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_VSpecialActionPerformed
        FrameSpecial.setVisible(true);
}//GEN-LAST:event_VSpecialActionPerformed

    private void MenuBarFocusGained(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_MenuBarFocusGained
        // TODO add your handling code here:
    }//GEN-LAST:event_MenuBarFocusGained

    private void TextField_Spec_SpecNameActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_TextField_Spec_SpecNameActionPerformed
        // TODO add your handling code here:
}//GEN-LAST:event_TextField_Spec_SpecNameActionPerformed

    private void RadioB_Special_GradeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_RadioB_Special_GradeActionPerformed
        ComboBox_Special_Grade.setEnabled(true);
        ComboBox_Special_Class.setEnabled(false);
        getSchedConflict();
}//GEN-LAST:event_RadioB_Special_GradeActionPerformed

    private void ComboBox_Special_ClassActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_ComboBox_Special_ClassActionPerformed
        getSchedConflict();
}//GEN-LAST:event_ComboBox_Special_ClassActionPerformed

    private void RadioB_Special_ClassActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_RadioB_Special_ClassActionPerformed
        ComboBox_Special_Grade.setEnabled(false);
        ComboBox_Special_Class.setEnabled(true);
        getSchedConflict();
}//GEN-LAST:event_RadioB_Special_ClassActionPerformed

    private void Check_Special_GTClassActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_Check_Special_GTClassActionPerformed
        if(Check_Special_GTClass.isSelected()){
            //if no special classes
            if (ComboBox_Special_GTClass.getItemCount()==1){
                Check_Special_GTClass.setSelected(false);
            }
            //are special classes
            else{
                ComboBox_Special_GTClass.setEnabled(true);
                ComboBox_Special_GTClass.setSelectedIndex(1);
            }
        }
        else{
            ComboBox_Special_GTClass.setEnabled(false);
        }
        getSchedConflict();
}//GEN-LAST:event_Check_Special_GTClassActionPerformed

    private void Check_Special_ManualActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_Check_Special_ManualActionPerformed
        //swap between manual and automatic timing seletion
        if(Check_Special_Manual.isSelected()){
            Auto_End.setVisible(false);
            Auto_Start.setVisible(false);
            AET_ComboBox.setVisible(false);
            AST_ComboBox.setVisible(false);
            Auto_LNG.setVisible(false);
            Auto_Time.setVisible(false);
            Man_Start.setVisible(true);
            Man_End.setVisible(true);
            MET_ComboBox.setVisible(true);
            MET_ComboBox.setEnabled(true);
            MST_ComboBox.setVisible(true);
            MST_ComboBox.setEnabled(true);
            ComboBox_Special_DOW.setVisible(true);
            ComboBox_Special_DOW.setEnabled(!Check_Special_Daily.isSelected());
        }
        else{
            Auto_End.setVisible(true);
            Auto_Start.setVisible(true);
            AET_ComboBox.setVisible(true);
            AET_ComboBox.setEnabled(true);
            AST_ComboBox.setVisible(true);
            AST_ComboBox.setEnabled(true);
            Auto_LNG.setVisible(true);
            Auto_Time.setEnabled(true);
            Auto_Time.setVisible(true);
            Man_Start.setVisible(false);
            Man_End.setVisible(false);
            MET_ComboBox.setVisible(false);
            MST_ComboBox.setVisible(false);
            ComboBox_Special_DOW.setVisible(false);
            ComboBox_Special_DOW.setEnabled(!Check_Special_Daily.isSelected());
        }
}//GEN-LAST:event_Check_Special_ManualActionPerformed

    private void VClassActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_VClassActionPerformed
        FrameClass.setVisible(true);
    }//GEN-LAST:event_VClassActionPerformed

    //set up actions for class window
    private void ComboBox_Class_ClassActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_ComboBox_Class_ClassActionPerformed
        int Grade=0;
        //if none selected turn all off
        if (ComboBox_Class_Class.getSelectedIndex()==0){
            Label_Class_Name.setEnabled(false);
            Label_Class_Grade.setEnabled(false);
            Text_Class_Name.setEnabled(false);
            Class_Grade_ComboBox.setEnabled(false);
            Button_Class_Save.setEnabled(false);
            Button_Class_Del.setEnabled(false);
            Button_Class_Revert.setEnabled(false);
            Text_Class_Name.setText("");
            Class_Grade_ComboBox.setSelectedIndex(0);
        }
        else{
            Label_Class_Name.setEnabled(true);
            Label_Class_Grade.setEnabled(true);
            Text_Class_Name.setEnabled(true);
            Class_Grade_ComboBox.setEnabled(true);
            Button_Class_Save.setEnabled(true);
            Button_Class_Del.setEnabled(true);
            Button_Class_Revert.setEnabled(true);
            if(ComboBox_Class_Class.getSelectedIndex()<=NumberOfClasses){
                Text_Class_Name.setText(classes[ComboBox_Class_Class.getSelectedIndex()].getName());
                Grade=convertToGradeInt(classes[ComboBox_Class_Class.getSelectedIndex()].getGrade());
                Class_Grade_ComboBox.setSelectedIndex(Grade);
            }
            if(ComboBox_Class_Class.getSelectedIndex()==NumberOfClasses+1){
                Text_Class_Name.setText("");
                Button_Class_Del.setEnabled(false);
                Button_Class_Revert.setEnabled(false);
            }
        }
}//GEN-LAST:event_ComboBox_Class_ClassActionPerformed

    private void ComboBox_Special_GradeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_ComboBox_Special_GradeActionPerformed
        getSchedConflict();
}//GEN-LAST:event_ComboBox_Special_GradeActionPerformed

    private void ComboBox_Special_GTClassActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_ComboBox_Special_GTClassActionPerformed
        getSchedConflict();
}//GEN-LAST:event_ComboBox_Special_GTClassActionPerformed

    private void MST_ComboBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_MST_ComboBoxActionPerformed
        if(MST_ComboBox.getSelectedIndex()>MET_ComboBox.getSelectedIndex()){
            MET_ComboBox.setSelectedIndex(MST_ComboBox.getSelectedIndex()+1);
        }
        getSchedConflict();
    }//GEN-LAST:event_MST_ComboBoxActionPerformed

    //actions performed when save clicked on class window
    private void Button_Class_SaveActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_Button_Class_SaveActionPerformed
        String ClassName;
        String ClassGrade;
        String OldClassName;

        changesMade=true;
        //get name and grade
        ClassName=Text_Class_Name.getText();
        ClassGrade=(String) Class_Grade_ComboBox.getSelectedItem();
        //check to see if the classroom exists
        if ((ComboBox_Class_Class.getSelectedIndex()!=0)&&(ComboBox_Class_Class.getSelectedIndex()!=NumberOfClasses+1)){
            if(classes[ComboBox_Class_Class.getSelectedIndex()].getGrade().equalsIgnoreCase("Special")){
                OldClassName=classes[ComboBox_Class_Class.getSelectedIndex()].getName();
                specClass=editClass(specClass, GetSpecRoomIndex(OldClassName), ClassName, ClassGrade, false);
                changeGoToClassNames(OldClassName,ClassName);
            }
            classes=editClass(classes, ComboBox_Class_Class.getSelectedIndex(), ClassName, ClassGrade, true);
        }
        //if !exists create the classroom
        else{
            if(((String)Class_Grade_ComboBox.getSelectedItem()).equalsIgnoreCase("Special")){
                classes=addClass(classes, ClassName, ClassGrade, true);
                specClass=addClass(specClass, ClassName, ClassGrade, false);
            }
            else{
                classes=addClass(classes, ClassName, ClassGrade, true);
            }
            //must check to see if new class already has specials for its grade
            if (NumberOfSpecials>0){
                for (int x=0;x<NumberOfSpecials+1;x++){
                    if(classes[GetClassRoomIndex(ClassName)].getGrade().equalsIgnoreCase(spec[x].getGrade())){
                        remFromSched(spec[x]);
                        addToSched(spec[x]);
                    }
                }
            }
        }
        //update the combobox list
        ComboBox_Class_Class.setModel(new javax.swing.DefaultComboBoxModel(updateClassComboList(true)));
        ComboBox_Class_Class.setSelectedIndex(GetClassRoomIndex(ClassName));
        ComboBox_Special_Class.setModel(new javax.swing.DefaultComboBoxModel(updateClassComboList(false)));
        ComboBox_Special_GTClass.setModel(new javax.swing.DefaultComboBoxModel(updateSpecialComboList()));
        ComboBox_Special_ChSpecial.setSelectedIndex(0);
        ComboBox_Schedule1_Classes.setModel(new javax.swing.DefaultComboBoxModel(updateClassComboList(false)));
        ComboBox_Schedule2_Classes.setModel(new javax.swing.DefaultComboBoxModel(updateClassComboList(false)));
        ComboBox_Schedule3_Classes.setModel(new javax.swing.DefaultComboBoxModel(updateClassComboList(false)));
        resetSpecialBox(0);

    }//GEN-LAST:event_Button_Class_SaveActionPerformed

    //delete button on class window
    private void Button_Class_DelActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_Button_Class_DelActionPerformed
        int index;
        int S_index;

        changesMade=true;
        //check to see if the classroom exists
        if ((ComboBox_Class_Class.getSelectedIndex()!=0)&&(ComboBox_Class_Class.getSelectedIndex()!=NumberOfClasses+1)){
            index = ComboBox_Class_Class.getSelectedIndex();
            //special case for Special Classes
            if(((String)Class_Grade_ComboBox.getSelectedItem()).equalsIgnoreCase("Special")){
                S_index=findClassroomIndex(specClass,Text_Class_Name.getText());
                checkSpecial("GTC",classes[index].getName());//remove Go To Special Class from any Specials
                checkSpecial("SCN",classes[index].getName());//remove Class from Specials
                specClass[S_index]=null;
                classes[index]=null;
                specClass=removeEmptyClass(S_index, specClass);
                classes=removeEmptyClass(index,classes);
                NumberOfClasses--;
                NumberOfSpecialClasses--;
            }
            //regular classes
            else{
                deleteSpecialsAsignedToClasses(classes[index]);
                classes[index]=null;
                classes=removeEmptyClass(index,classes);
                NumberOfClasses--;
            }
            updateSpecialBox(0);
            resetSpecialBox(0);
            resetComboBoxes();
            displaySched();
        }

    }//GEN-LAST:event_Button_Class_DelActionPerformed

    private void Text_Class_NameActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_Text_Class_NameActionPerformed
        
    }//GEN-LAST:event_Text_Class_NameActionPerformed

    //revert button on class window
    private void Button_Class_RevertActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_Button_Class_RevertActionPerformed
        Text_Class_Name.setText(classes[ComboBox_Class_Class.getSelectedIndex()].getName());
        Class_Grade_ComboBox.setSelectedIndex(convertToGradeInt(classes[ComboBox_Class_Class.getSelectedIndex()].getGrade()));
    }//GEN-LAST:event_Button_Class_RevertActionPerformed

    //when class selected in schedule window
    private void ComboBox_Schedule1_ClassesActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_ComboBox_Schedule1_ClassesActionPerformed
        displaySched(1);
}//GEN-LAST:event_ComboBox_Schedule1_ClassesActionPerformed

    //choose a special in the special window
    private void ComboBox_Special_ChSpecialActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_ComboBox_Special_ChSpecialActionPerformed
        int Index=ComboBox_Special_ChSpecial.getSelectedIndex();
        //add a special selected
        if (Index==NumberOfSpecials+1){
            specialAddSetup();
        }
        //none or a special selected
        else{
            resetSpecialBox(Index);
        }
        getSchedConflict();
    }//GEN-LAST:event_ComboBox_Special_ChSpecialActionPerformed

    //save button on special window
    private void Button_Special_SaveActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_Button_Special_SaveActionPerformed
        int index = ComboBox_Special_ChSpecial.getSelectedIndex();
        int classChosen = ComboBox_Special_Class.getSelectedIndex();
        boolean changeToAuto;

        changesMade=true;

        //make sure Auto time is not longer than time frame
        //set up in auto times
        if((AET_ComboBox.getSelectedIndex()-AST_ComboBox.getSelectedIndex())*5<Integer.parseInt(Auto_Time.getText())){
            Auto_Time.setText(Integer.toString((AET_ComboBox.getSelectedIndex()-AST_ComboBox.getSelectedIndex())*5));
        }

        //illegal setting. Class radial button, but no class selected
        if (classChosen==0&&RadioB_Special_Class.isSelected()){
            //tell user cannot have the class set to none
            popUp("ERROR!<br>THIS SPECIAL HAS NOT BEEN SAVED<br>When asigning a Special to a class, you must choose a class to asign it to.");
        }
        else if(TextField_Spec_SpecName.getText().equalsIgnoreCase("")){
            popUp("ERROR!<br>THIS SPECIAL HAS NOT BEEN SAVED<br>Please fill in the name of the special.");
        }
        else{
            //Edit the current Special
            if ((index!=0)&&(index!=NumberOfSpecials+1)){
                changeToAuto=!Check_Special_Manual.isSelected()&&spec[index].isManPlacement();
                if(Check_Special_Manual.isSelected()||changeToAuto){
                    //remove from Schedule
                    remFromSched(spec[index]);
                    //edit the special
                    index=editSpecial(index);
                    //add the special to the schedule
                    ///but check to see if it is still manual placement
                    if(spec[index].isManPlacement()){
                        addToSched(spec[index]);
                    }
                }
                else{
                    //edit the special
                    index=editSpecial(index);
                }
            }
            //Create a new special and add it to the schedule
            else if (index==NumberOfSpecials+1){
                index=addSpecial(TextField_Spec_SpecName.getText());
                //add the special to the schedule if index is non-zero
                //and is manual placement
                //do not automatically schedule auto place specials
                if (index!=0&&spec[index].isManPlacement()){
                    addToSched(spec[index]);
                }
            }
            //update the combobox list if index !=0
            if (index!=0){
                updateSpecialBox(index);
                displaySched();
            }
        }
    }//GEN-LAST:event_Button_Special_SaveActionPerformed

    //make sure end times are after start times
    private void MET_ComboBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_MET_ComboBoxActionPerformed
        if(MST_ComboBox.getSelectedIndex()>MET_ComboBox.getSelectedIndex()){
            MET_ComboBox.setSelectedIndex(MST_ComboBox.getSelectedIndex()+1);
        }
        getSchedConflict();
    }//GEN-LAST:event_MET_ComboBoxActionPerformed

    //make sure end times are after start times and auto length is
    //less than times selected
    private void AST_ComboBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_AST_ComboBoxActionPerformed
        if(AST_ComboBox.getSelectedIndex()>AET_ComboBox.getSelectedIndex()){
            AET_ComboBox.setSelectedIndex(AST_ComboBox.getSelectedIndex()+1);
        }
        if((AET_ComboBox.getSelectedIndex()-AST_ComboBox.getSelectedIndex())*5<Integer.parseInt(Auto_Time.getText())){
            Auto_Time.setText(Integer.toString((AET_ComboBox.getSelectedIndex()-AST_ComboBox.getSelectedIndex())*5));
        }
    }//GEN-LAST:event_AST_ComboBoxActionPerformed

    //make sure end times are after start times and auto length is
    //less than times selected
    private void AET_ComboBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_AET_ComboBoxActionPerformed
        if(AST_ComboBox.getSelectedIndex()>AET_ComboBox.getSelectedIndex()){
            AET_ComboBox.setSelectedIndex(AST_ComboBox.getSelectedIndex()+1);
        }
        if((AET_ComboBox.getSelectedIndex()-AST_ComboBox.getSelectedIndex())*5<Integer.parseInt(Auto_Time.getText())){
            Auto_Time.setText(Integer.toString((AET_ComboBox.getSelectedIndex()-AST_ComboBox.getSelectedIndex())*5));
        }
    }//GEN-LAST:event_AET_ComboBoxActionPerformed

    //make sure auto length is less than times selected
    private void Auto_TimeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_Auto_TimeActionPerformed
        if((AET_ComboBox.getSelectedIndex()-AST_ComboBox.getSelectedIndex())*5<Integer.parseInt(Auto_Time.getText())){
            Auto_Time.setText(Integer.toString((AET_ComboBox.getSelectedIndex()-AST_ComboBox.getSelectedIndex())*5));
        }
    }//GEN-LAST:event_Auto_TimeActionPerformed

    //delete button on special
    //need to add delete from schedule also
    private void Button_Special_DelActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_Button_Special_DelActionPerformed
        int index;

        changesMade=true;

        index = ComboBox_Special_ChSpecial.getSelectedIndex();

        delSpecial(index);
        updateSpecialBox(0);
    }//GEN-LAST:event_Button_Special_DelActionPerformed

    //revert button on special window
    private void Button_Special_RevertActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_Button_Special_RevertActionPerformed
        int index;
        index=ComboBox_Special_ChSpecial.getSelectedIndex();
        resetSpecialBox(index);
    }//GEN-LAST:event_Button_Special_RevertActionPerformed

    private void ComboBox_Special_DOWActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_ComboBox_Special_DOWActionPerformed
        getSchedConflict();
}//GEN-LAST:event_ComboBox_Special_DOWActionPerformed

    private void Check_Special_DailyActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_Check_Special_DailyActionPerformed
        if (Check_Special_Daily.isSelected()){
            ComboBox_Special_DOW.setEnabled(false);
        }
        else{
            ComboBox_Special_DOW.setEnabled(true);
        }
        getSchedConflict();
    }//GEN-LAST:event_Check_Special_DailyActionPerformed

    //menu item. Add class.
    private void EAdd_ClassActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_EAdd_ClassActionPerformed
        FrameClass.setVisible(true);
        ComboBox_Class_Class.setSelectedIndex(NumberOfClasses+1);
    }//GEN-LAST:event_EAdd_ClassActionPerformed

    //menu item. Delete class
    private void FSaveActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_FSaveActionPerformed
        if (FileName==null){
            //get filename
            FileName=saveFileAs();
            //if filename is null, cancel out
            if (FileName==null){
                Frame_YN_Save.setVisible(false);
                return;
            }
        }
        saveAllItems(FileName);
    }//GEN-LAST:event_FSaveActionPerformed

    private void FOpen_SchedActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_FOpen_SchedActionPerformed
        if(changesMade){
            ynBoxState=2;
            //pop up save question box
            Frame_YN_Save.setVisible(true);
        }
        else{
            //erase all info
            fullReset();

            //choose file to open
            FileName = openFile();
            //if filename is null, cancel out
            if (FileName==null){
                Frame_YN_Save.setVisible(false);
                return;
            }
            loadAll(FileName);
            updateSpecialBox(0);
            displaySched();
            resetComboBoxes();
            resetSpecialBox(0);
        }
    }//GEN-LAST:event_FOpen_SchedActionPerformed

    private void FSave_AsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_FSave_AsActionPerformed
        FileName =  saveFileAs();
        //if filename is null, cancel out
        if (FileName==null){
            Frame_YN_Save.setVisible(false);
            return;
        }
        saveAllItems(FileName);
    }//GEN-LAST:event_FSave_AsActionPerformed

    private void FImport_SpecActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_FImport_SpecActionPerformed
        String fName=null;

        //choose file to open
        fName = openFile();
        //if filename is null, cancel out
        if (fName==null){
            Frame_YN_Save.setVisible(false);
            return;
        }
        if(!fName.endsWith(".sched")){
            
            popUp("ERROR<br><br>Not a valid schedule file.");
            return;
        }
        loadSpecials(fName,true);
        updateSpecialBox(0);
        displaySched();
        resetComboBoxes();
        resetSpecialBox(0);
    }//GEN-LAST:event_FImport_SpecActionPerformed

    private void FNew_SchedActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_FNew_SchedActionPerformed

        //check to see if a save is needed
        if (changesMade){
            ynBoxState=1;
            //pop up save question box
            Frame_YN_Save.setVisible(true);
        }
        else{
            fullReset();
            updateSpecialBox(0);
            resetSpecialBox(0);
            resetComboBoxes();
            displaySched();
       }
    }//GEN-LAST:event_FNew_SchedActionPerformed

    private void Button_YN_SaveActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_Button_YN_SaveActionPerformed
        if (FileName==null){
            //get filename
            FileName=saveFileAs();
            //if filename is null, cancel out
            if (FileName==null){        
                Frame_YN_Save.setVisible(false);
                return;
            }
        }
        saveAllItems(FileName);
        Frame_YN_Save.setVisible(false);
        //set up for new schedule
        fullReset();
        if(ynBoxState==2){
            //choose file to open
            FileName = openFile();
            //if filename is null, cancel out
            if (FileName==null){
                Frame_YN_Save.setVisible(false);
                return;
            }
            loadAll(FileName);
        }
        updateSpecialBox(0);
        resetSpecialBox(0);
        resetComboBoxes();
        displaySched();
        changesMade=false;
        ynBoxState=0;
}//GEN-LAST:event_Button_YN_SaveActionPerformed

    private void Button_YN_NoActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_Button_YN_NoActionPerformed
        Frame_YN_Save.setVisible(false);
        fullReset();
        if(ynBoxState==2){
            //choose file to open
            FileName = openFile();
            //if filename is null, cancel out
            if (FileName==null){
                Frame_YN_Save.setVisible(false);
                return;
            }
            loadAll(FileName);
            //popUp("Done Loading");
        }
        updateSpecialBox(0);
        resetSpecialBox(0);
        resetComboBoxes();
        displaySched();
        changesMade=false;
        ynBoxState=0;
}//GEN-LAST:event_Button_YN_NoActionPerformed

    private void EAdd_SpecActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_EAdd_SpecActionPerformed
        ComboBox_Special_ChSpecial.setSelectedIndex(NumberOfSpecials+1);
        specialAddSetup();
    }//GEN-LAST:event_EAdd_SpecActionPerformed

    private void Button_PU_OKActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_Button_PU_OKActionPerformed
        Frame_PopUp.setVisible(false);
}//GEN-LAST:event_Button_PU_OKActionPerformed

    private void Button_YN_SaveAsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_Button_YN_SaveAsActionPerformed
        FileName=saveFileAs();
        //if filename is null, cancel out
        if (FileName==null){
            Frame_YN_Save.setVisible(false);
            return;
        }
        saveAllItems(FileName);
        Frame_YN_Save.setVisible(false);
        //set up for new schedule
        fullReset();
        if(ynBoxState==2){
            //choose file to open
            FileName = openFile();
            //if filename is null, cancel out
            if (FileName==null){
                Frame_YN_Save.setVisible(false);
                return;
            }
            loadAll(FileName);
            //popUp("Done Loading");
        }
        updateSpecialBox(0);
        resetSpecialBox(0);
        resetComboBoxes();
        displaySched();
        changesMade=false;
        ynBoxState=0;
    }//GEN-LAST:event_Button_YN_SaveAsActionPerformed

    private void FQuitActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_FQuitActionPerformed
        System.exit(0);
}//GEN-LAST:event_FQuitActionPerformed

    private void FExportActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_FExportActionPerformed
        ExcelXML xmlHandler = new ExcelXML();
        String F_Name=null;
        xmlHandler.startGenerate();
        for(int x=1;x<NumberOfClasses+1;x++){
            xmlHandler.createWorkSheet(createTable(classes[x]), classes[x]);
        }
        xmlHandler.endGenerate();
        F_Name=saveFileAs();
        if(!F_Name.endsWith(".xml")){
            F_Name=F_Name+".xml";
        }
        exportXML(F_Name, xmlHandler.printXML());
}//GEN-LAST:event_FExportActionPerformed

    private void VSchedule2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_VSchedule2ActionPerformed
        FrameSchedule2.setVisible(true);
}//GEN-LAST:event_VSchedule2ActionPerformed

    private void ComboBox_Schedule2_ClassesActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_ComboBox_Schedule2_ClassesActionPerformed
        displaySched(2);
}//GEN-LAST:event_ComboBox_Schedule2_ClassesActionPerformed

    private void ComboBox_Schedule3_ClassesActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_ComboBox_Schedule3_ClassesActionPerformed
        displaySched(3);
}//GEN-LAST:event_ComboBox_Schedule3_ClassesActionPerformed

    private void VSchedule3ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_VSchedule3ActionPerformed
        FrameSchedule3.setVisible(true);
}//GEN-LAST:event_VSchedule3ActionPerformed

    private void EAuto_SchedActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_EAuto_SchedActionPerformed
        autoSched();
    }//GEN-LAST:event_EAuto_SchedActionPerformed

    //redisplay all combo boxes
    private void resetComboBoxes(){
        ComboBox_Class_Class.setModel(new javax.swing.DefaultComboBoxModel(updateClassComboList(true)));
        ComboBox_Class_Class.setSelectedIndex(0);
        ComboBox_Special_Class.setModel(new javax.swing.DefaultComboBoxModel(updateClassComboList(false)));
        ComboBox_Special_GTClass.setModel(new javax.swing.DefaultComboBoxModel(updateSpecialComboList()));
        ComboBox_Special_ChSpecial.setSelectedIndex(0);
        ComboBox_Schedule1_Classes.setModel(new javax.swing.DefaultComboBoxModel(updateClassComboList(false)));
        ComboBox_Schedule2_Classes.setModel(new javax.swing.DefaultComboBoxModel(updateClassComboList(false)));
        ComboBox_Schedule3_Classes.setModel(new javax.swing.DefaultComboBoxModel(updateClassComboList(false)));
    }

    //bring up the notification pop up
    private void popUp(String Message){
        String fullMessage=null;

        fullMessage="<HTML><Center>"+Message+"</Center></HTML>";

        Label_PU_Text.setText(fullMessage);
        Frame_PopUp.setVisible(true);
    }

    //setup to add a special
    private void specialAddSetup(){
            TextField_Spec_SpecName.setEditable(true);
            TextField_Spec_SpecName.setEnabled(true);
            TextField_Spec_SpecName.setText("");
            RadioB_Special_Grade.setEnabled(true);
            ComboBox_Special_Class.setSelectedIndex(0);
            ComboBox_Special_Grade.setSelectedIndex(0);
            if(ComboBox_Special_Class.getItemCount()==1){
                RadioB_Special_Class.setEnabled(false);
                RadioB_Special_Class.setSelected(false);
                ComboBox_Special_Class.setEnabled(false);
                RadioB_Special_Grade.setSelected(true);
                ComboBox_Special_Grade.setEnabled(true);
            }
            else{
                RadioB_Special_Class.setEnabled(true);
                RadioB_Special_Class.setSelected(true);
                ComboBox_Special_Class.setEnabled(true);
                RadioB_Special_Grade.setSelected(false);
                ComboBox_Special_Grade.setEnabled(false);
            }
            Check_Special_Daily.setEnabled(true);
            Check_Special_Daily.setSelected(false);
            Check_Special_GTClass.setEnabled(true);
            Check_Special_GTClass.setSelected(false);
            ComboBox_Special_GTClass.setEnabled(false);
            ComboBox_Special_GTClass.setSelectedIndex(0);
            Check_Special_Manual.setEnabled(true);
            Check_Special_Manual.setSelected(true);
            Auto_End.setVisible(false);
            Auto_Start.setVisible(false);
            AET_ComboBox.setVisible(false);
            AET_ComboBox.setSelectedIndex(0);
            AST_ComboBox.setVisible(false);
            AST_ComboBox.setSelectedIndex(0);
            Auto_LNG.setVisible(false);
            Auto_Time.setVisible(false);
            Man_Start.setVisible(true);
            Man_Start.setEnabled(true);
            Man_End.setVisible(true);
            Man_End.setEnabled(true);
            MET_ComboBox.setVisible(true);
            MET_ComboBox.setEnabled(true);
            MET_ComboBox.setSelectedIndex(1);
            MST_ComboBox.setVisible(true);
            MST_ComboBox.setEnabled(true);
            MST_ComboBox.setSelectedIndex(0);
            ComboBox_Special_DOW.setSelectedIndex(0);
            ComboBox_Special_DOW.setEnabled(true);
            ComboBox_Special_DOW.setVisible(true);
            Button_Special_Del.setEnabled(false);
            Button_Special_Revert.setEnabled(false);
            Button_Special_Save.setEnabled(true);
    }

    //edit an existing special
    private int editSpecial(int index){
        spec[index].setName(TextField_Spec_SpecName.getText());
        spec[index].setSingleClass(RadioB_Special_Class.isSelected());
        spec[index].setSingleClassName((String)ComboBox_Special_Class.getSelectedItem());
        spec[index].setWholeGrade(RadioB_Special_Grade.isSelected());
        spec[index].setGrade((String)ComboBox_Special_Grade.getSelectedItem());
        spec[index].setDaily(Check_Special_Daily.isSelected());
        spec[index].setGoToClass(Check_Special_GTClass.isSelected());
        spec[index].setGoToClassName((String)ComboBox_Special_GTClass.getSelectedItem());
        spec[index].setManPlacement(Check_Special_Manual.isSelected());
        spec[index].setStartTime((String)MST_ComboBox.getSelectedItem());
        spec[index].setEndTime((String)MET_ComboBox.getSelectedItem());
        spec[index].setEarlyStartTime((String)AST_ComboBox.getSelectedItem());
        spec[index].setLateEndTime((String)AET_ComboBox.getSelectedItem());
        spec[index].setLenInMin(Integer.parseInt(Auto_Time.getText()));
        spec[index].setDOW(ComboBox_Special_DOW.getSelectedIndex());
        return index;
    }

    //create a new special
    private int addSpecial(String name){
        Special toAdd= new Special();
        int index=0;

        toAdd.setName(name);

        //check to see if special exists
        if (specialExists(toAdd)){
            popUp("ERROR<br>SPECIAL NOT SAVED<br>Each special must have an unique name. If you are trying to edit a special, please choose it from the pull down menu.");
            return index;
        }
        NumberOfSpecials++;

        spec = addToSpecList(spec, toAdd);
        
        for(int x=0;x<NumberOfSpecials+1;x++){
            if (spec[x].getName().equalsIgnoreCase(name)){
                index=x;
            }
        }
        SpecialCounter++;
        spec[index].setID(SpecialCounter);
        editSpecial(index);
        return index;
    }

    //add specials from a load
    private int addLoadedSpecial(Special loadSpecial){
        int index=0;


        if (!specialExists(loadSpecial)){
            NumberOfSpecials++;
            spec = addToSpecList(spec, loadSpecial);
            for(int x=0;x<NumberOfSpecials+1;x++){
                if (spec[x].getName().equalsIgnoreCase(loadSpecial.getName())){
                    index=x;
                }
            }
            SpecialCounter++;
            spec[index].setID(SpecialCounter);
            //editSpecial(index);
        }
        return index;
    }

    private boolean specialExists(Special checkThis){
        boolean exists = false;

        for (int x=0;x<NumberOfSpecials+1&&!exists;x++){
            if (spec[x].getName().equalsIgnoreCase(checkThis.getName())){
                exists=true;
            }
        }

        return exists;
    }

    //add a class that is a Special Room to the specials list
    private Special[] addToSpecList(Special[] ExistingList, Special toAdd){
        Special[] newList=new Special[NumberOfSpecials+1];

        for (int x=0;x<NumberOfSpecials;x++){
            newList[x]=ExistingList[x];
        }
        newList[NumberOfSpecials]=toAdd;

        newList=SortedSpecList(newList);

        return newList;
    }

    //alphabatise the list
    private Special[] SortedSpecList(Special[] list){
        boolean sorted;
        Special temp;

        do{
            sorted=true;
            for(int x=1;x<NumberOfSpecials;x++){
                if (list[x].getName().compareToIgnoreCase(list[x+1].getName())>0){
                    temp=list[x];
                    list[x]=list[x+1];
                    list[x+1]=temp;
                    sorted=false;
                }
            }
        }
        while(!sorted);

        return list;
    }

    //remove empty slots from the list
    private void removeEmptySpec(int index){
        Special[] temp =new Special[NumberOfSpecials];
        for (int x=index;x<NumberOfSpecials;x++){
            spec[x]=spec[x+1];
        }
        for (int x=0;x<NumberOfSpecials;x++){
            temp[x]=spec[x];
        }
        spec=temp;
        NumberOfSpecials--;
    }

    private void resetSpecialBox(int Index){
        resetSpecialBox(Index, spec);
    }

    private void resetSpecialBox(Special passThough){
        Special[] newSpec = new Special[1];
        newSpec[0]=passThough;
        resetSpecialBox(0,newSpec);
    }

    //redraw special window
    private void resetSpecialBox(int Index, Special[] specialList){
            TextField_Spec_SpecName.setEnabled(!specialList[Index].getName().equalsIgnoreCase("none"));
            TextField_Spec_SpecName.setText(specialList[Index].getName());
            RadioB_Special_Class.setEnabled(!specialList[Index].getName().equalsIgnoreCase("none"));
            RadioB_Special_Class.setSelected(specialList[Index].isSingleClass());
            RadioB_Special_Grade.setEnabled(!specialList[Index].getName().equalsIgnoreCase("none"));
            RadioB_Special_Grade.setSelected(specialList[Index].isWholeGrade());
            if(specialList[Index].isSingleClass()){
                ComboBox_Special_Class.setEnabled(true);
                ComboBox_Special_Class.setSelectedItem(specialList[Index].getSingleClassName());
            }
            else{
                ComboBox_Special_Class.setEnabled(false);
                ComboBox_Special_Class.setSelectedIndex(0);
            }
            if(specialList[Index].isWholeGrade()){
                ComboBox_Special_Grade.setEnabled(true);
                ComboBox_Special_Grade.setSelectedItem(specialList[Index].getGrade());
            }
            else{
                ComboBox_Special_Grade.setEnabled(false);
                ComboBox_Special_Grade.setSelectedIndex(0);
            }
            Check_Special_Daily.setEnabled(!specialList[Index].getName().equalsIgnoreCase("none"));
            Check_Special_Daily.setSelected(specialList[Index].isDaily());
            Check_Special_GTClass.setEnabled(!specialList[Index].getName().equalsIgnoreCase("none"));
            Check_Special_GTClass.setSelected(specialList[Index].isGoToClass());
            if(specialList[Index].isGoToClass()){
                ComboBox_Special_GTClass.setEnabled(true);
                ComboBox_Special_GTClass.setSelectedItem(specialList[Index].getGoToClassName());
            }
            else{
                ComboBox_Special_GTClass.setEnabled(false);
                ComboBox_Special_GTClass.setSelectedIndex(0);
            }
            Check_Special_Manual.setEnabled(!specialList[Index].getName().equalsIgnoreCase("none"));
            Check_Special_Manual.setSelected(specialList[Index].isManPlacement());
            Auto_End.setVisible(!specialList[Index].isManPlacement());
            Auto_Start.setVisible(!specialList[Index].isManPlacement());
            AET_ComboBox.setVisible(!specialList[Index].isManPlacement());
            AET_ComboBox.setEnabled(!specialList[Index].isManPlacement());
            AET_ComboBox.setSelectedItem(specialList[Index].getLateEndTime());
            AST_ComboBox.setVisible(!specialList[Index].isManPlacement());
            AST_ComboBox.setEnabled(!specialList[Index].isManPlacement());
            AST_ComboBox.setSelectedItem(specialList[Index].getEarlyStartTime());
            Auto_LNG.setVisible(!specialList[Index].isManPlacement());
            Auto_Time.setVisible(!specialList[Index].isManPlacement());
            Auto_Time.setEnabled(!specialList[Index].getName().equalsIgnoreCase("none"));
            Auto_Time.setText(Integer.toString(specialList[Index].getLenInMin()));
            Man_Start.setVisible(specialList[Index].isManPlacement());
            Man_Start.setEnabled(!specialList[Index].getName().equalsIgnoreCase("none"));
            Man_End.setVisible(specialList[Index].isManPlacement());
            Man_End.setEnabled(!specialList[Index].getName().equalsIgnoreCase("none"));
            MET_ComboBox.setVisible(specialList[Index].isManPlacement());
            MET_ComboBox.setEnabled(specialList[Index].isManPlacement()&&!specialList[Index].getName().equalsIgnoreCase("none"));
            MET_ComboBox.setSelectedItem(specialList[Index].getEndTime());
            MST_ComboBox.setVisible(specialList[Index].isManPlacement());
            MST_ComboBox.setEnabled(specialList[Index].isManPlacement()&&!specialList[Index].getName().equalsIgnoreCase("none"));
            MST_ComboBox.setSelectedItem(specialList[Index].getStartTime());
            ComboBox_Special_DOW.setVisible(specialList[Index].isManPlacement());
            ComboBox_Special_DOW.setEnabled(!specialList[Index].isDaily()&&specialList[Index].isManPlacement()&&!specialList[Index].getName().equalsIgnoreCase("none"));
            ComboBox_Special_DOW.setSelectedIndex(specialList[Index].getDOW());
            Button_Special_Del.setEnabled(!specialList[Index].getName().equalsIgnoreCase("none"));
            Button_Special_Revert.setEnabled(!specialList[Index].getName().equalsIgnoreCase("none"));
            Button_Special_Save.setEnabled(!specialList[Index].getName().equalsIgnoreCase("none"));

    }

    //get the index number of a classroom from the name given
    private int findClassroomIndex(Classroom[] RoomSet, String Name){
        int index=0;

        for (int x=1;x<RoomSet.length;x++){
            if(RoomSet[x].getName().equalsIgnoreCase(Name)){
                index=x;
            }
        }
        return index;
    }

    //set the name and grade of a classroom
    //then sort the list
    private Classroom[] editClass(Classroom[] classRoom, int index, String Name, String Grade, boolean RegClass){
        classRoom[index].setName(Name);
        classRoom[index].setGrade(Grade);
        classRoom=SortedClassList(classRoom,RegClass);
        return classRoom;
    }

    //add a classroom to the list
    private Classroom[] addClass(Classroom[] classRoom, String name, String Grade, boolean RegClass){
        Classroom toAdd = new Classroom();
        
        //check for non empty name
        if (name.equalsIgnoreCase("")){
            popUp("ERROR<br>CLASS NOT SAVED<br>There must be a class name.");
            return classRoom;
        }
        //check to see if class name is taken
        if (findClassroomIndex(classRoom, name)!=0){
            popUp("ERROR<br>CLASS NOT SAVED<br>This class name has already been taken. If you are trying to edit a class, please select it from the pull down menu.");
            return classRoom;
        }

        //create class
        toAdd.createClass();

        if (RegClass){
            NumberOfClasses++;
        }
        else{
            NumberOfSpecialClasses++;
        }

        toAdd.setName(name);
        toAdd.setGrade(Grade);
        classRoom=addToClassList(classRoom, toAdd, RegClass);
        return classRoom;
    }

    //creates a new Classroom array to expand the current array
    private Classroom[] addToClassList(Classroom[] ExistingList, Classroom toAdd, boolean RegClass){
        Classroom[] newList;
        int counter;

        //class list is a regualr class list
        if (RegClass){
            newList=new Classroom[NumberOfClasses+1];
            counter = NumberOfClasses;
        }
        //class list is special class list only
        else{
            newList=new Classroom[NumberOfSpecialClasses+1];
            counter = NumberOfSpecialClasses;
        }

        for (int x=0;x<counter;x++){
            newList[x]=ExistingList[x];
        }
        newList[counter]=toAdd;

        newList=SortedClassList(newList, RegClass);

        return newList;
    }

    //sort the class list
    private Classroom[] SortedClassList(Classroom[] list, boolean RegClass){
        boolean sorted;
        Classroom temp;
        int counter;

        if(RegClass){
            counter = NumberOfClasses;
        }
        else{
            counter = NumberOfSpecialClasses;
        }
        do{
            sorted=true;
            for(int x=1;x<counter;x++){
                if (list[x].getName().compareToIgnoreCase(list[x+1].getName())>0){
                    temp=list[x];
                    list[x]=list[x+1];
                    list[x+1]=temp;
                    sorted=false;
                }
            }
        }
        while(!sorted);

        return list;
    }

    //Convert the grade string to an Int
    private int convertToGradeInt(String grade_String){
        int grade_int=0;

        if (grade_String.equalsIgnoreCase("1")) grade_int=1;
        else if (grade_String.equalsIgnoreCase("2")) grade_int=2;
        else if (grade_String.equalsIgnoreCase("3")) grade_int=3;
        else if (grade_String.equalsIgnoreCase("4")) grade_int=4;
        else if (grade_String.equalsIgnoreCase("5")) grade_int=5;
        else if (grade_String.equalsIgnoreCase("special")) grade_int=6;

        return grade_int;
    }

    //get classroom index by name
    private int GetClassRoomIndex(String ClassName){
        int index=0;

        for(int x=0;x<NumberOfClasses+1;x++){
            if (ClassName.equalsIgnoreCase(classes[x].getName())){
                index=x;
            }
        }

        return index;
    }

    //get special class index by name
    private int GetSpecRoomIndex(String SpecialName){
        int index=0;

        for(int x=0;x<NumberOfSpecialClasses+1;x++){
            if (SpecialName.equalsIgnoreCase(specClass[x].getName())){
                index=x;
            }
        }

        return index;
    }

    //when a special class room changes name, 
    //we need to repoint the specials to that room
    private void changeGoToClassNames(String OldName, String NewName){
        for (int x=0;x<NumberOfSpecials+1;x++){
            if (spec[x].getGoToClassName().equalsIgnoreCase(OldName)){
                spec[x].setGoToClassName(NewName);
            }
        }
    }
    
    //deletes a classroom from the list
    private Classroom[] removeEmptyClass(int index, Classroom[] room){
        int T_Rooms=room.length-1;
        Classroom[] temp =new Classroom[T_Rooms];
        for (int x=index;x<T_Rooms;x++){
            room[x]=room[x+1];
        }
        for (int x=0;x<T_Rooms;x++){
            temp[x]=room[x];
        }
        room=temp;

        return room;
    }

    //generates class listing combo list
    private String[] updateClassComboList(boolean wAddClass){
        String[] ComboBox_Model;

        if(wAddClass) ComboBox_Model = new String[NumberOfClasses+2];
        else{
            ComboBox_Model = new String[NumberOfClasses+1];
        }
        for(int x=0; x<NumberOfClasses+1;x++){
            ComboBox_Model[x]=classes[x].getName();
        }
        if(wAddClass)ComboBox_Model[NumberOfClasses+1]="Add New Class";
        return ComboBox_Model;
    }

    private void updateSpecialBox(int index) {
        //update the combobox list
        ComboBox_Special_ChSpecial.setModel(new javax.swing.DefaultComboBoxModel(updateSpecComboList()));
        ComboBox_Special_ChSpecial.setSelectedIndex(index);
        resetSpecialBox(index);
    }

    //generates special class combo lists
    private String[] updateSpecialComboList(){
        boolean wAddClass = false;
        String[] ComboBox_Model;

        if(wAddClass) ComboBox_Model = new String[NumberOfClasses+2];
        else{
            ComboBox_Model = new String[NumberOfSpecialClasses+1];
        }
        for(int x=0; x<NumberOfSpecialClasses+1;x++){
            ComboBox_Model[x]=specClass[x].getName();
        }
        if(wAddClass)ComboBox_Model[NumberOfClasses+1]="Add New Class";
        return ComboBox_Model;
    }

    //generates Specials combo list
    private String[] updateSpecComboList(){
        String[] ComboBox_Model;

        ComboBox_Model = new String[NumberOfSpecials+2];
        for(int x=0; x<NumberOfSpecials+1;x++){
            ComboBox_Model[x]=spec[x].getName();
        }
        ComboBox_Model[NumberOfSpecials+1]="Add New Special";
        return ComboBox_Model;
    }

    //create the schedule table
    private Object[][] createTable (Classroom room){
        Object[][] table=null;
        int Days;
        int Times;

        int Hour = room.getTimeInfo()[0];
        int Minutes = room.getTimeInfo()[1];
        int Time_Blocks = room.getTimeInfo()[2];

        Days = 1 + room.getSched().length;
        Times = room.getSched()[0].length;

        table = new Object[Times][Days];

        for (int T=0;T<Times;T++){
            for (int D=0;D<Days;D++){
                if (D==0){
                    table[T][D]=stringTime(Hour,Minutes);
                }
                else{
                    //error in pulling
                    if (room.getSchedSlot(D-1, T)==-1){
                        table[T][D]="Error!";
                    }
                    //nothing scheduled
                    else if (room.getSchedSlot(D-1, T)==0){
                        table[T][D]="";
                    }
                    //scheduled item
                    else{
                        //put classroom name in for specials
                        if (room.getGrade().equalsIgnoreCase("Special")){
                            //add class name
                            if(spec[convertFromID(room.getSchedSlot(D-1, T))].isWholeGrade()){
                                table[T][D]=("Grade "+spec[convertFromID(room.getSchedSlot(D-1, T))].getGrade());
                            }
                            else{
                                table[T][D]=(spec[convertFromID(room.getSchedSlot(D-1, T))].getSingleClassName());
                            }
                        }
                        //regular classrooms
                        else{
                            //if going to a special classroom, put that name in
                            if (spec[convertFromID(room.getSchedSlot(D-1, T))].isGoToClass()){
                                table[T][D]=(spec[convertFromID(room.getSchedSlot(D-1, T))].getGoToClassName());
                            }
                            //put in special name in
                            else{
                                table[T][D]=(spec[convertFromID(room.getSchedSlot(D-1, T))].getName());
                            }
                        }
                    }
                }
            }
            Minutes=Minutes+Time_Blocks;
            if (Minutes>=60){
                Minutes=Minutes-60;
                Hour++;
            }
        }

        return table;
    }

    //convert from Special ID to Special Index
    private int convertFromID(int id){
        int index = 0;

        for (int x=0; x<NumberOfSpecials+1;x++){
            if (spec[x].getID()==id){
                index=x;
            }
        }
        return index;
    }

    private String stringTime (int[] time){
        return stringTime (time[0],time[1]);
    }

    //turn int time to string time
    private String stringTime(int h, int m){
        String time="mystery";
        String H;
        String M;
        if (h>12){
            h=h-12;
        }
        if (h<10){
            H="0"+Integer.toString(h);
        }
        else {
            H=Integer.toString(h);
        }
        if (m<10){
            M="0"+Integer.toString(m);
        }
        else {
            M=Integer.toString(m);
        }
        time=H+":"+M;
        return time;
    }

    //check the Specials for items to remove from editing classes
    //"GTC" Remove Go to Special Room field
    //"SCN" Remove Classroom assigned to special
    private void checkSpecial(String Instruction, String NameToCheck){
        int index;
        if (Instruction.equalsIgnoreCase("GTC")){
            do{
                index = 0;
                for (int x=0;x<spec.length;x++){
                    if (spec[x].getGoToClassName().equalsIgnoreCase(NameToCheck)){
                        index=x;
                    }
                }
                if (index!=0){
                    spec[index].setGoToClass(false);
                    spec[index].setGoToClassName("none");
                }
            }while(index !=0);
        }
        else if(Instruction.equalsIgnoreCase("SCN")){
            do{
                index = 0;
                for (int x=0;x<spec.length;x++){
                    if (spec[x].getSingleClassName().equalsIgnoreCase(NameToCheck)){
                        index=x;
                    }
                }
                if (index!=0){
                    spec[index].setSingleClass(false);
                    spec[index].setSingleClassName("none");
                }
            }while(index !=0);
        }
        updateSchedules();
    }

    //Deletes Specials
    private void delSpecial (int index){
        //remove special from schedules
        remFromSched(spec[index]);

        //delete the special
        spec[index]=null;
        removeEmptySpec(index);
        displaySched();
    }

    //run though specials and delete any assigned to that class
    private void deleteSpecialsAsignedToClasses(Classroom classToDelete){
        for (int x=0;x<NumberOfSpecials+1;x++){
            if (classToDelete.getName().equalsIgnoreCase(spec[x].getSingleClassName())){
                delSpecial(x);
                x--;
            }
        }
    }

    //add special to schedules
    //must check for any conflicts
    //before adding to the schedules
    private void addToSched(Special Spec){
        int classIndex;
        boolean isWholeGradeGood = true;
        boolean isSpecRoomGood = true;

        //Check Special Room for conflicts first
        if (Spec.isGoToClass()){
            classIndex=GetClassRoomIndex(Spec.getGoToClassName());
            isSpecRoomGood=classes[classIndex].noConflict(Spec);
        }
        if (isSpecRoomGood){
            //add to single class
            if (Spec.isSingleClass()){
                classIndex=GetClassRoomIndex(Spec.getSingleClassName());
                //check for conflicts
                if(classes[classIndex].noConflict(Spec)){
                    classes[classIndex].addSpecialToSchedule(Spec);
                }
                else{
                    //post conflict error
                    popUp("SCHEDULING CONFLICT<br>This special was saved, but not scheduled due to conflict. Please note the conflicts in the special window.");
                    return;
                }
            }
            //add to all of the same grade
            else if (Spec.isWholeGrade()){
                //check for any conflicts
                for (int x=1;x<NumberOfClasses+1&&isWholeGradeGood;x++){
                    if (classes[x].getGrade().equalsIgnoreCase(Spec.getGrade())){
                        isWholeGradeGood=classes[x].noConflict(Spec);
                    }
                }
                if(isWholeGradeGood){
                    for (int x=1;x<NumberOfClasses+1;x++){
                        if (classes[x].getGrade().equalsIgnoreCase(Spec.getGrade())){
                            classes[x].addSpecialToSchedule(Spec);
                        }
                    }
                }
                else{
                    //post conflict error
                    popUp("SCHEDULING CONFLICT<br>This special was saved, but not scheduled due to conflict. Please note the conflicts in the special window.");
                    return;
                }
            }
            //add to the special room
            if (Spec.isGoToClass()){
                classIndex=GetClassRoomIndex(Spec.getGoToClassName());
                classes[classIndex].addSpecialToSchedule(Spec);
            }
        }
        else{
            //post conflict error
            popUp("SCHEDULING CONFLICT<br>This special was saved, but not scheduled due to conflict. Please note the conflicts in the special window.");
        }
    }

    //delete a special from the class schedules
    private void remFromSched(Special spec){
        int classIndex;
        //single class specials
        if (spec.isSingleClass()){
            classIndex=GetClassRoomIndex(spec.getSingleClassName());
            classes[classIndex].remSpecial(spec);
        }
        //whole grade specials
        else if(spec.isWholeGrade()){
            for (int x=1;x<NumberOfClasses+1;x++){
                if (classes[x].getGrade().equalsIgnoreCase(spec.getGrade())){
                    classes[x].remSpecial(spec);
                }
            }
        }
        //specials that go to a specific classroom
        if (spec.isGoToClass()){
            classIndex=GetClassRoomIndex(spec.getGoToClassName());
            classes[classIndex].remSpecial(spec);
        }
    }

    //will update schedules when automation is added
    private void updateSchedules(){
        
    }

    //takes 1's and 0's and convertes then to true/false
    private boolean stringToBoolean(String bool){
        if (bool.equalsIgnoreCase("1")){
            return true;
        }
        else{
            return false;
        }
    }


    private void getSchedConflict(){
        int index = ComboBox_Special_ChSpecial.getSelectedIndex();
        int conflict=0;
        int totalConflicts=0;
        int classIndex;
        String classConflicts="";
        Special temp = new Special();
        
        temp.setName(TextField_Spec_SpecName.getText());
        temp.setSingleClass(RadioB_Special_Class.isSelected());
        temp.setSingleClassName((String)ComboBox_Special_Class.getSelectedItem());
        temp.setWholeGrade(RadioB_Special_Grade.isSelected());
        temp.setGrade((String)ComboBox_Special_Grade.getSelectedItem());
        temp.setDaily(Check_Special_Daily.isSelected());
        temp.setGoToClass(Check_Special_GTClass.isSelected());
        temp.setGoToClassName((String)ComboBox_Special_GTClass.getSelectedItem());
        temp.setManPlacement(Check_Special_Manual.isSelected());
        temp.setStartTime((String)MST_ComboBox.getSelectedItem());
        temp.setEndTime((String)MET_ComboBox.getSelectedItem());
        temp.setEarlyStartTime((String)AST_ComboBox.getSelectedItem());
        temp.setLateEndTime((String)AET_ComboBox.getSelectedItem());
        temp.setLenInMin(Integer.parseInt(Auto_Time.getText()));
        temp.setDOW(ComboBox_Special_DOW.getSelectedIndex());
        //check to see if this already exists or if it is new
        if ((index!=0)&&(index!=NumberOfSpecials+1)){
            temp.setID(spec[index].getID());
        }
        else{
            temp.setID(0);
        }

        
        //check for conflicts
        //if multiple conflicts exist, only the
        //last class room will be displayed
        
        //check for conflicts for going to a classroom
        if (temp.isGoToClass()){
            classIndex=GetClassRoomIndex(temp.getGoToClassName());
            if (!classes[classIndex].noConflict(temp)){
                conflict=classIndex;
                totalConflicts++;
                classConflicts += classes[conflict].getName()+" ";
            }
        }
        //check for conflicts for the classroom assigned
        if (temp.isSingleClass()){
            classIndex=GetClassRoomIndex(temp.getSingleClassName());
            if(!classes[classIndex].noConflict(temp)){
                conflict=classIndex;
                totalConflicts++;
                classConflicts += classes[conflict].getName()+" ";
            }
        }
        //check for conflicts for the whole grade
        if (temp.isWholeGrade()){
            for (int x=1;x<NumberOfClasses+1;x++){
                if (classes[x].getGrade().equalsIgnoreCase(temp.getGrade())){
                    if(!classes[x].noConflict(temp)){
                        conflict=x;
                        totalConflicts++;
                        classConflicts += classes[x].getName()+" ";
                    }
                }
            }
        }
        if (totalConflicts==0){
            TextField_Special_Conflict.setText("No Conflicts");
        }
        else{
            TextField_Special_Conflict.setText("("+Integer.toString(totalConflicts)+") "+classConflicts);
        }
    }

    /************
     IO Starts Here
     ************/

    //save the classes and specials
    private void saveAllItems(String F_Name){


        String Output="***Classrooms Start Here***\n";

        //Class room info
        for(int x=1;x<NumberOfClasses+1;x++){
            //Class Name
            Output = Output + classes[x].getName()+"\n";
            //Class Grade
            Output = Output + classes[x].getGrade()+"\n";
        }

        Output = Output + "***Specials Start Here***\n";

        //Special information
        for(int x=1;x<NumberOfSpecials+1;x++){
            //Special Name
            Output = Output + spec[x].getName()+"\n";
            //Is for only one class
            if (spec[x].isSingleClass()){
                Output = Output + "1\n";
                Output = Output + spec[x].getSingleClassName()+"\n";
            }
            else{
                Output = Output + "0\n";
                Output = Output + "none\n";
            }
            //Is for the whole grade
            if (spec[x].isWholeGrade()){
                Output = Output + "1\n";
                Output = Output + spec[x].getGrade()+"\n";
            }
            else{
                Output = Output + "0\n";
                Output = Output + "k\n";
            }
            //Is a daily special
            if (spec[x].isDaily()){
                Output = Output + "1\n";
            }
            else{
                Output = Output + "0\n";
            }
            //Goes to a special classroom
            if (spec[x].isGoToClass()){
                Output = Output + "1\n";
                Output = Output + spec[x].getGoToClassName()+"\n";
            }
            else{
                Output = Output + "0\n";
                Output = Output + ""+"\n";
            }
            //Is manually placed
            if (spec[x].isManPlacement()){
                Output = Output + "1\n";
            }
            else{
                Output = Output + "0\n";
            }
            //start time
            Output = Output + spec[x].getStartTime()+"\n";
            //end time
            Output = Output + spec[x].getEndTime()+"\n";
            //Day of the week
            Output = Output + Integer.toString(spec[x].getDOW())+"\n";
            //earliest start time
            Output = Output + spec[x].getEarlyStartTime()+"\n";
            //latest end time
            Output = Output + spec[x].getLateEndTime()+"\n";
            //special length
            Output = Output + Integer.toString(spec[x].getLenInMin())+"\n";
            /*//special ID
            Output = Output + Integer.toString(spec[x].getID())+"\n";*/
        }


        //System.out.println(Output);
        //write to file
        try{
            BufferedWriter buffWriter= new BufferedWriter(new FileWriter(F_Name));
            buffWriter.write(Output);
            buffWriter.close();
        }
        catch(IOException e){
            System.out.println("Errror: "+e.getMessage());
        }
    }

    private void loadAll(String F_Name){
        if(!F_Name.endsWith(".sched")){
            popUp("ERROR<br><br>Not a valid schedule file.");
            return;
        }
        classes[0] = new Classroom();
        specClass[0] = new Classroom();
        spec[0] = new Special();
        spec[0].setID(0);
        classes[0].createClass();
        specClass[0].createClass();
        classes[0].setName("none");
        specClass[0].setName("none");
        loadClasses(F_Name);
        loadSpecials(F_Name);
    }

    private void loadClasses(String F_Name){
        if(!F_Name.endsWith(".sched")){
            popUp("ERROR<br><br>Not a valid schedule file.1");
            return;
        }
        try{
            FileInputStream fileStream = new FileInputStream(F_Name);
            DataInputStream dataStream = new DataInputStream(fileStream);
            BufferedReader buffRead = new BufferedReader(new InputStreamReader(dataStream));
            String fileLineInput;
            String className, classGrade;

            //read first line
            fileLineInput=buffRead.readLine();
            if(!fileLineInput.equalsIgnoreCase("***Classrooms Start Here***")){
                popUp("ERROR<br><br>FILE IS CORRUPTED<br><br>Could not load.");
                return;
            }

            while(fileLineInput!=null&&!fileLineInput.equalsIgnoreCase("***Specials Start Here***")){
                //check for clasrrom header
                if(!fileLineInput.equalsIgnoreCase("***Classrooms Start Here***")){
                    //get class name
                    className=fileLineInput;
                    //get class grade
                    fileLineInput=buffRead.readLine();
                    classGrade=fileLineInput;
                    if(classGrade.equalsIgnoreCase("special")){
                        classes=addClass(classes, className, classGrade, true);
                        specClass=addClass(specClass, className, classGrade, false);
                    }
                    else{
                        classes=addClass(classes, className, classGrade, true);
                    }
                }
                fileLineInput=buffRead.readLine();
            }
        }
        catch (Exception e){
            System.out.println(e.getMessage());
        }
    }

    private void loadSpecials (String F_Name){
        loadSpecials (F_Name, false);
    }

    private void loadSpecials(String F_Name, boolean isImport){
        if(!F_Name.endsWith(".sched")){
            popUp("ERROR<br><br>Not a valid schedule file.");
            return;
        }
        try{
            FileInputStream fileStream = new FileInputStream(F_Name);
            DataInputStream dataStream = new DataInputStream(fileStream);
            BufferedReader buffRead = new BufferedReader(new InputStreamReader(dataStream));
            String fileLineInput;
            int index;

            //read first line
            fileLineInput=buffRead.readLine();
            if(!fileLineInput.equalsIgnoreCase("***Classrooms Start Here***")){
                popUp("ERROR<br><br>FILE IS CORRUPTED<br><br>Could not load.");
                return;
            }

            //skip through the Classroom section
            while(!fileLineInput.equalsIgnoreCase("***Specials Start Here***")&&fileLineInput!=null){
                fileLineInput=buffRead.readLine();
            }
            fileLineInput=buffRead.readLine();

            while(fileLineInput!=null){
                Special newSpec = new Special();
                //name
                newSpec.setName(fileLineInput);
                //is a single class
                newSpec.setSingleClass(stringToBoolean(buffRead.readLine()));
                if (isImport) newSpec.setSingleClass(false);
                //single class name
                newSpec.setSingleClassName(buffRead.readLine());
                if (isImport) newSpec.setSingleClassName("none");
                //Is for the whole grade
                newSpec.setWholeGrade(stringToBoolean(buffRead.readLine()));
                if (isImport) newSpec.setWholeGrade(false);
                //what grade
                newSpec.setGrade(buffRead.readLine());
                //Is a daily special
                newSpec.setDaily(stringToBoolean(buffRead.readLine()));
                //Goes to a special classroom
                newSpec.setGoToClass(stringToBoolean(buffRead.readLine()));
                if (isImport) newSpec.setGoToClass(false);
                //Which classroom to go to
                newSpec.setGoToClassName(buffRead.readLine());
                if (isImport) newSpec.setGoToClassName("none");
                //Is manually placed
                newSpec.setManPlacement(stringToBoolean(buffRead.readLine()));
                //start time
                newSpec.setStartTime(buffRead.readLine());
                //end time
                newSpec.setEndTime(buffRead.readLine());
                //Day of the week
                newSpec.setDOW(Integer.parseInt(buffRead.readLine()));
                //earliest start time
                newSpec.setEarlyStartTime(buffRead.readLine());
                //latest end time
                newSpec.setLateEndTime(buffRead.readLine());
                //special length
                newSpec.setLenInMin(Integer.parseInt(buffRead.readLine()));
                //special ID
                /*newSpec.setID(Integer.parseInt(buffRead.readLine()));*/
                fileLineInput=buffRead.readLine();

                //place info into special box to be read
                //if the special name isn't taken
                //if (GetSpecIndex(newSpec.getName())==0){
                    //resetSpecialBox(newSpec);
                    index=addLoadedSpecial(newSpec);
                    //add the special to the schedule
                    if(spec[index].isManPlacement()){
                        addToSched(spec[index]);
                    }
                //}
            }
        }
        catch (Exception e){
            popUp("ERROR<br><br>Error loading file. FIle was not loaded. Error message:<br><br>"+e.getMessage());
            //System.out.println(e.getMessage());
        }
    }

    private String openFile(){
        String name=null;
        JFileChooser chooser = new JFileChooser();
        
        chooser.showOpenDialog(rootPane);
        try{
            name = chooser.getSelectedFile().getAbsolutePath();
        }
        catch (Exception e){
            if (e.toString().equalsIgnoreCase("java.lang.nullPointerException")){
                popUp("Aborting Load");
            }
            else{
                popUp("ABORTING LOAD<br><br>Got Error Code:<br><br>"+e);
            }
        }

        return name;
    }

    private String saveFileAs(){
        String name=null;
        JFileChooser chooser = new JFileChooser();

        chooser.showSaveDialog(rootPane);
        try{
            name = chooser.getSelectedFile().getAbsolutePath();
        }
        catch (Exception e){
            if (e.toString().equalsIgnoreCase("java.lang.nullPointerException")){
                popUp("Aborting Save");
            }
            else{
                popUp("ABORTING LOAD<br><br>Got Error Code:<br><br>"+e);
            }
        }

        if (!name.endsWith(".sched")){
            name=name+".sched";
        }

        return name;
    }

    private void exportXML(String F_Name, String XMLCode){
        //write to file
        try{
            BufferedWriter buffWriter= new BufferedWriter(new FileWriter(F_Name));
            buffWriter.write(XMLCode);
            buffWriter.close();
        }
        catch(IOException e){
            System.out.println("Errror: "+e.getMessage());
        }

    }

    /****************
     * AI Starts Here
     ****************/

    //searches the specials to see what still need to be scheduled
    //sorts that list and then passes it to be scheduled
    private void autoSched(){
        Special[] listToSchedule;
        //popUp("This Feature is currently disabled. Please manually schedule all specials.");
        listToSchedule=priority();
        /*for(int x=0;x<listToSchedule.length;x++){
            System.out.println(listToSchedule[x].getName()+"\t\t"+listToSchedule[x].getPriority());
        }*/
        autoSched(listToSchedule);
        displaySched();
    }

    //AutoSchedule the sorted list
    private void autoSched(Special[] list){
        //test options for each
        for(int x=0; x<list.length;x++){
            if (findSlot(list[x])){
                //once a good slot is found set to manual
                list[x].setManPlacement(true);
                //and add it to the schedule
                addToSched(list[x]);
            }
        }
    }

    private boolean findSlot(Special item){
        String startTime,endTime;
        int [] sTime = new int[2];
        int [] eTime = new int[2];
        int classIndex;
        int totalTime;
        int DOW=0;//day of the week
        boolean slotFound=true;
        boolean atEndOfBounds=false;

        //initial start time
        startTime=item.getEarlyStartTime();
        sTime=intTime(startTime);
        totalTime=item.getLenInMin();

        do{
            slotFound=true;
            //get endtime to test slot
            eTime[0]=sTime[0];
            eTime[1]=sTime[1]+totalTime;
            while(eTime[1]>=60){
                eTime[1]=eTime[1]-60;
                eTime[0]++;
            }
            endTime=stringTime(eTime);
            if(convertTime(endTime)>convertTime(item.getLateEndTime())){
                startTime=item.getEarlyStartTime();
                sTime=intTime(startTime);
                DOW++;
                //get endtime to test slot
                eTime[0]=sTime[0];
                eTime[1]=sTime[1]+totalTime;
                while(eTime[1]>=60){
                    eTime[1]=eTime[1]-60;
                    eTime[0]++;
                }
                endTime=stringTime(eTime);
            }
            //place slots into special
            item.setStartTime(startTime);
            item.setEndTime(endTime);
            item.setDOW(DOW);

            //check to see if slot is good
            //first check for GTS room       //check for conflicts for going to a classroom
            if (item.isGoToClass()){
                classIndex=GetClassRoomIndex(item.getGoToClassName());
                if (!classes[classIndex].noConflict(item)){
                    slotFound=false;
                }
            }
            //check for conflicts for the classroom assigned
            if (item.isSingleClass()){
                classIndex=GetClassRoomIndex(item.getSingleClassName());
                if(!classes[classIndex].noConflict(item)){
                    slotFound=false;
                }
            }
            //check for conflicts for the whole grade
            if (item.isWholeGrade()){
                for (int x=1;x<NumberOfClasses+1;x++){
                    if (classes[x].getGrade().equalsIgnoreCase(item.getGrade())){
                        if(!classes[x].noConflict(item)){
                            slotFound=false;
                        }
                    }
                }
            }
            //find new start time
            sTime[1]=sTime[1]+5;
            if(sTime[1]>=60){
                sTime[0]++;
                sTime[1]=0;
            }
            startTime=stringTime(sTime);
            //check to see if end of bounds is reached
            //check for daily items
            if(item.isDaily()){
                if(convertTime(endTime)>=convertTime(item.getLateEndTime())){
                    atEndOfBounds=true;
                }
            }
            //not a daily
            else{
                if(convertTime(endTime)+DOW*100>=convertTime(item.getLateEndTime())+400){
                    atEndOfBounds=true;
                }
            }
        }while(!slotFound&&!atEndOfBounds);
        return slotFound;
    }
    /*
     * Priority listing of specials to sort
     * Priority list is as such from high to low:
     *  1.Daily Schedule                    = 100,000
     *  2.Goes to a Special Classroom       =  10,000
     *  3.Entire grade                      =   1,000
     *  4.Individual Class                  =     100
     *  5.Smallest time range to schedule
     *  6.Length of special (longer has higher priority)
     * Priorities will be combined
     */
    private Special[] priority(){
        Special[] autoSchedSpec;//the specials that are auto sched
        Special temp;
        boolean sorted=true;
        int daily = 100000;
        int gtc = 10000;
        int wg = 1000;
        int sc = 100;
        int noSchedSpec=0;//number of auto sched specials

        //find the number of auto placement specials
        for(int x=0;x < NumberOfSpecials+1;x++){
            if(!spec[x].isManPlacement()){
                noSchedSpec++;
            }
        }
        //create the array for auto sched specials
        autoSchedSpec=new Special[noSchedSpec];
        noSchedSpec=0;
        //populate array
        for(int x=0;x<NumberOfSpecials+1;x++){
            if (!spec[x].isManPlacement()){
                autoSchedSpec[noSchedSpec]=spec[x];
                //add priority points to special
                if(autoSchedSpec[noSchedSpec].isDaily())autoSchedSpec[noSchedSpec].increasePriority(daily);
                if(autoSchedSpec[noSchedSpec].isGoToClass())autoSchedSpec[noSchedSpec].increasePriority(gtc);
                if(autoSchedSpec[noSchedSpec].isWholeGrade())autoSchedSpec[noSchedSpec].increasePriority(wg);
                if(autoSchedSpec[noSchedSpec].isSingleClass())autoSchedSpec[noSchedSpec].increasePriority(sc);
                noSchedSpec++;
            }
        }
        //Sort the array
        do{
            sorted=true;
            for(int x=0;x<noSchedSpec-1;x++){
                //check priority points
                if(autoSchedSpec[x].getPriority()<autoSchedSpec[x+1].getPriority()){
                    temp=autoSchedSpec[x];
                    autoSchedSpec[x]=autoSchedSpec[x+1];
                    autoSchedSpec[x+1]=temp;
                    sorted=false;
                }
                //if priority points are the same check ranges and lengths
                else if(autoSchedSpec[x].getPriority()==autoSchedSpec[x+1].getPriority()){
                    if (compareThese(autoSchedSpec[x], autoSchedSpec[x+1])>0){
                        temp=autoSchedSpec[x];
                        autoSchedSpec[x]=autoSchedSpec[x+1];
                        autoSchedSpec[x+1]=temp;
                        sorted=false;
                    }
                }
            }
        }while(!sorted);

        return autoSchedSpec;
    }

    /*
     * compare second to first
     * -1 first has higher priority
     * 0 first equal priority to second
     * 1 first is lower priority
    */
    private int compareThese(Special first, Special second){
        int value=0;
        int range1,range2;

        range1=convertTime(first.getLateEndTime())-convertTime(first.getEarlyStartTime());
        range2=convertTime(second.getLateEndTime())-convertTime(second.getEarlyStartTime());

        //smaller range has higher priority
        if (range1<range2)value=-1;
        else if(range1>range2)value=1;

        //if they have the same range compare time length
        if(value==0){
            //longer schedule time has higher priority
            if (first.getLenInMin()<second.getLenInMin())value=1;
            else if (first.getLenInMin()>second.getLenInMin())value=-1;
        }
        return value;
    }

    private int convertTime(String S_Time){
        int hour,min;
        int totalTime;
        //convert time to an int
        //time will be in HH:MM format
        hour=Integer.parseInt(S_Time.substring(0, 2));//pull out hour
        min=Integer.parseInt(S_Time.substring(3, 5));//pull out minute
        if(hour<4){
            totalTime=(hour+12)*60;
        }
        else{
            totalTime=(hour)*60;
        }
        totalTime=totalTime+min;

        return totalTime;
    }

    private int[] intTime(String sTime){
        int[] intTime=new int[2];
        int hour,min;

        //convert time to an int
        //time will be in HH:MM format
        hour=Integer.parseInt(sTime.substring(0, 2));//pull out hour
        min=Integer.parseInt(sTime.substring(3, 5));//pull out minute

        intTime[0]=hour;
        intTime[1]=min;
        return intTime;
    }


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JComboBox AET_ComboBox;
    private javax.swing.JComboBox AST_ComboBox;
    private javax.swing.JLabel Auto_End;
    private javax.swing.JLabel Auto_LNG;
    private javax.swing.JLabel Auto_Start;
    private javax.swing.JTextField Auto_Time;
    private javax.swing.JButton Button_Class_Del;
    private javax.swing.JButton Button_Class_Revert;
    private javax.swing.JButton Button_Class_Save;
    private javax.swing.JButton Button_PU_OK;
    private javax.swing.JButton Button_Special_Del;
    private javax.swing.JButton Button_Special_Revert;
    private javax.swing.JButton Button_Special_Save;
    private javax.swing.JButton Button_YN_No;
    private javax.swing.JButton Button_YN_Save;
    private javax.swing.JButton Button_YN_SaveAs;
    private javax.swing.JCheckBox Check_Special_Daily;
    private javax.swing.JCheckBox Check_Special_GTClass;
    private javax.swing.JCheckBox Check_Special_Manual;
    private javax.swing.ButtonGroup Class_Grade_Button_Group;
    private javax.swing.JComboBox Class_Grade_ComboBox;
    private javax.swing.JComboBox ComboBox_Class_Class;
    private javax.swing.JComboBox ComboBox_Schedule1_Classes;
    private javax.swing.JComboBox ComboBox_Schedule2_Classes;
    private javax.swing.JComboBox ComboBox_Schedule3_Classes;
    private javax.swing.JComboBox ComboBox_Special_ChSpecial;
    private javax.swing.JComboBox ComboBox_Special_Class;
    private javax.swing.JComboBox ComboBox_Special_DOW;
    private javax.swing.JComboBox ComboBox_Special_GTClass;
    private javax.swing.JComboBox ComboBox_Special_Grade;
    private javax.swing.JMenuItem EAdd_Class;
    private javax.swing.JMenuItem EAdd_Spec;
    private javax.swing.JMenuItem EAuto_Sched;
    private javax.swing.JMenuItem FExport;
    private javax.swing.JMenuItem FImport_Spec;
    private javax.swing.JMenuItem FNew_Sched;
    private javax.swing.JMenuItem FOpen_Sched;
    private javax.swing.JMenuItem FQuit;
    private javax.swing.JMenuItem FSave;
    private javax.swing.JMenuItem FSave_As;
    private javax.swing.JInternalFrame FrameClass;
    private javax.swing.JInternalFrame FrameSchedule1;
    private javax.swing.JInternalFrame FrameSchedule2;
    private javax.swing.JInternalFrame FrameSchedule3;
    private javax.swing.JInternalFrame FrameSpecial;
    private javax.swing.JInternalFrame Frame_PopUp;
    private javax.swing.JInternalFrame Frame_YN_Save;
    private javax.swing.JLabel Label_Class_Grade;
    private javax.swing.JLabel Label_Class_Name;
    private javax.swing.JLabel Label_PU_Text;
    private javax.swing.JComboBox MET_ComboBox;
    private javax.swing.JMenu MEdit;
    private javax.swing.JMenu MFile;
    private javax.swing.JComboBox MST_ComboBox;
    private javax.swing.JMenu MView;
    private javax.swing.JLabel Man_End;
    private javax.swing.JLabel Man_Start;
    private javax.swing.JMenuBar MenuBar;
    private javax.swing.JRadioButton RadioB_Special_Class;
    private javax.swing.JRadioButton RadioB_Special_Grade;
    private javax.swing.JTable Table_Schedule1;
    private javax.swing.JTable Table_Schedule2;
    private javax.swing.JTable Table_Schedule3;
    private javax.swing.JTextField TextField_Spec_SpecName;
    private javax.swing.JTextField TextField_Special_Conflict;
    private javax.swing.JTextField Text_Class_Name;
    private javax.swing.JMenuItem VClass;
    private javax.swing.JMenuItem VSchedule1;
    private javax.swing.JMenuItem VSchedule2;
    private javax.swing.JMenuItem VSchedule3;
    private javax.swing.JMenuItem VSpecial;
    private javax.swing.JDesktopPane jDesktopPane1;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel10;
    private javax.swing.JLabel jLabel11;
    private javax.swing.JLabel jLabel12;
    private javax.swing.JLabel jLabel13;
    private javax.swing.JLabel jLabel14;
    private javax.swing.JLabel jLabel15;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JLabel jLabel8;
    private javax.swing.JLabel jLabel9;
    private javax.swing.JLabel jLabel_Sched1_Class_Grade;
    private javax.swing.JLabel jLabel_Sched1_Class_Name;
    private javax.swing.JLabel jLabel_Sched2_Class_Grade;
    private javax.swing.JLabel jLabel_Sched2_Class_Name;
    private javax.swing.JLabel jLabel_Sched3_Class_Grade;
    private javax.swing.JLabel jLabel_Sched3_Class_Name;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JScrollPane jScrollPane3;
    private javax.swing.JSeparator jSeparator1;
    private javax.swing.JTabbedPane jTabbedPane1;
    // End of variables declaration//GEN-END:variables

}
